/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import neoforge.com.hollingsworth.schematic.client.renderer.DireRenderTypes;
import neoforge.com.hollingsworth.schematic.client.renderer.DireVertexConsumer;
import neoforge.com.hollingsworth.schematic.client.renderer.DireVertexConsumerSquished;
import neoforge.com.hollingsworth.schematic.common.util.Color;
import neoforge.com.hollingsworth.schematic.mixin.ItemRendererAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;

public class DireRenderMethods {
    private static Map<BlockEntityType<?>, BlockEntityRenderer<?>> renderers = ImmutableMap.of();

    public static void renderBETransparent(BlockState pState, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, float alpha) {
        MultiplyAlphaRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new MultiplyAlphaRenderTypeBuffer(pBufferSource, alpha);
        ItemStack stack = new ItemStack((ItemLike)pState.getBlock());
        ((ItemRendererAccessor)Minecraft.getInstance().getItemRenderer()).getBlockEntityRenderer().renderByItem(stack, ItemDisplayContext.NONE, pPoseStack, (MultiBufferSource)multiplyAlphaRenderTypeBuffer, pPackedLight, pPackedOverlay);
    }

    public static void renderBESquished(BlockState pState, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, float alpha) {
        SquishedRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new SquishedRenderTypeBuffer(pBufferSource, alpha, pPoseStack.last().pose());
        ItemStack stack = new ItemStack((ItemLike)pState.getBlock());
        ((ItemRendererAccessor)Minecraft.getInstance().getItemRenderer()).getBlockEntityRenderer().renderByItem(stack, ItemDisplayContext.NONE, pPoseStack, (MultiBufferSource)multiplyAlphaRenderTypeBuffer, pPackedLight, pPackedOverlay);
    }

    public static void renderCopy(PoseStack matrix, BlockPos startPos, BlockPos endPos, Color color) {
        if (startPos == null || endPos == null) {
            return;
        }
        int x = Math.min(startPos.getX(), endPos.getX());
        int y = Math.min(startPos.getY(), endPos.getY());
        int z = Math.min(startPos.getZ(), endPos.getZ());
        int dx = startPos.getX() > endPos.getX() ? startPos.getX() + 1 : endPos.getX() + 1;
        int dy = startPos.getY() > endPos.getY() ? startPos.getY() + 1 : endPos.getY() + 1;
        int dz = startPos.getZ() > endPos.getZ() ? startPos.getZ() + 1 : endPos.getZ() + 1;
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer builder = buffer.getBuffer(DireRenderTypes.lines());
        matrix.pushPose();
        Matrix4f matrix4f = matrix.last().pose();
        PoseStack.Pose matrix3f = matrix.last();
        int colorRGB = color.getRGB();
        builder.addVertex(matrix4f, (float)x, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, (float)x, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, -1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, -1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)x, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, -1.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, -1.0f);
        builder.addVertex(matrix4f, (float)x, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)y, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)z).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        builder.addVertex(matrix4f, (float)dx, (float)dy, (float)dz).setColor(colorRGB).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
        buffer.endBatch(DireRenderTypes.lines());
        matrix.popPose();
    }

    public static class MultiplyAlphaRenderTypeBuffer
    implements MultiBufferSource {
        private final MultiBufferSource inner;
        private final float constantAlpha;

        public MultiplyAlphaRenderTypeBuffer(MultiBufferSource inner, float constantAlpha) {
            this.inner = inner;
            this.constantAlpha = constantAlpha;
        }

        public VertexConsumer getBuffer(RenderType type) {
            RenderType localType = type;
            if (localType instanceof RenderType.CompositeRenderType) {
                ResourceLocation texture = ((RenderStateShard.TextureStateShard)((RenderType.CompositeRenderType)localType).state().textureState).texture.orElse(InventoryMenu.BLOCK_ATLAS);
                localType = RenderType.entityTranslucentCull((ResourceLocation)texture);
            } else if (localType.toString().equals(Sheets.translucentCullBlockSheet().toString())) {
                localType = Sheets.translucentCullBlockSheet();
            }
            return new DireVertexConsumer(this.inner.getBuffer(localType), this.constantAlpha);
        }
    }

    public static class SquishedRenderTypeBuffer
    implements MultiBufferSource {
        private final MultiBufferSource inner;
        private final float squishAmt;
        private final Matrix4f matrix4f;

        public SquishedRenderTypeBuffer(MultiBufferSource inner, float squishAmt, Matrix4f matrix4f) {
            this.inner = inner;
            this.squishAmt = squishAmt;
            this.matrix4f = matrix4f;
        }

        public VertexConsumer getBuffer(RenderType type) {
            RenderType localType = type;
            if (localType instanceof RenderType.CompositeRenderType) {
                ResourceLocation texture = ((RenderStateShard.TextureStateShard)((RenderType.CompositeRenderType)localType).state().textureState).texture.orElse(InventoryMenu.BLOCK_ATLAS);
                localType = RenderType.entityTranslucentCull((ResourceLocation)texture);
            } else if (localType.toString().equals(Sheets.translucentCullBlockSheet().toString())) {
                localType = Sheets.translucentCullBlockSheet();
            }
            return new DireVertexConsumerSquished(this.inner.getBuffer(localType), 0.0f, 0.0f, 0.0f, 1.0f, this.squishAmt, 1.0f, this.matrix4f);
        }
    }
}

