/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import neoforge.com.hollingsworth.schematic.client.renderer.FakeRenderingWorld;
import neoforge.com.hollingsworth.schematic.client.renderer.StatePos;
import neoforge.com.hollingsworth.schematic.client.renderer.TagPos;
import neoforge.com.hollingsworth.schematic.mixin.StructureTemplateAccessor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StructureRenderData {
    public ArrayList<StatePos> statePosCache;
    public BoundingBox boundingBox;
    public BlockPos anchorPos;
    public Map<RenderType, MeshData.SortState> sortStates = new HashMap<RenderType, MeshData.SortState>();
    public Map<RenderType, MeshData> meshDatas = new HashMap<RenderType, MeshData>();
    public String name;
    public String blockprintsId;
    public FakeRenderingWorld fakeRenderingWorld;
    public StructureTemplate structureTemplate;
    public Rotation rotation;
    public Mirror mirror;
    public boolean flipped = false;
    public BlockPos lastRenderPos = null;
    public int sortCounter;
    public final Map<RenderType, ByteBufferBuilder> builders = RenderType.chunkBufferLayers().stream().collect(Collectors.toMap(renderType -> renderType, type -> new ByteBufferBuilder(type.bufferSize())));
    public Map<RenderType, VertexBuffer> vertexBuffers = RenderType.chunkBufferLayers().stream().collect(Collectors.toMap(renderType -> renderType, type -> new VertexBuffer(VertexBuffer.Usage.STATIC)));
    public final Map<RenderType, BufferBuilder> bufferBuilders = new HashMap<RenderType, BufferBuilder>();
    public StructurePlaceSettings structurePlaceSettings;
    public double distanceFromCameraCast = 25.0;

    public StructureRenderData(StructureTemplate structureTemplate, String name, String blockprintsId) {
        StructureTemplateAccessor accessor = (StructureTemplateAccessor)structureTemplate;
        List<StructureTemplate.Palette> palettes = accessor.getPalettes();
        if (palettes.isEmpty()) {
            return;
        }
        StructureTemplate.Palette palette = palettes.get(0);
        this.statePosCache = new ArrayList();
        this.structureTemplate = structureTemplate;
        for (StructureTemplate.StructureBlockInfo blockInfo : palette.blocks()) {
            this.statePosCache.add(new StatePos(blockInfo.state(), blockInfo.pos()));
        }
        this.structurePlaceSettings = new StructurePlaceSettings();
        this.boundingBox = structureTemplate.getBoundingBox(this.structurePlaceSettings, new BlockPos(0, 0, 0));
        this.name = name;
        this.blockprintsId = blockprintsId;
        this.rotation = Rotation.NONE;
        this.mirror = Mirror.NONE;
    }

    public void rotate(Rotation rotateBy) {
        this.rotation = this.rotation.getRotated(rotateBy);
        this.statePosCache = StatePos.rotate(this.statePosCache, new ArrayList<TagPos>(), rotateBy);
        this.boundingBox = this.structureTemplate.getBoundingBox(this.structurePlaceSettings.setRotation(this.rotation), new BlockPos(0, 0, 0));
    }

    public void mirror(boolean mirror) {
        this.mirror = mirror ? Mirror.FRONT_BACK : Mirror.NONE;
        this.boundingBox = this.structureTemplate.getBoundingBox(this.structurePlaceSettings.setMirror(this.mirror), new BlockPos(0, 0, 0));
    }

    public void flip() {
        this.flipped = !this.flipped;
        this.mirror(this.flipped);
    }

    public ByteBufferBuilder getByteBuffer(RenderType renderType) {
        return this.builders.get(renderType);
    }
}

