/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.ArrayList;
import java.util.Map;
import neoforge.com.hollingsworth.schematic.client.RaycastHelper;
import neoforge.com.hollingsworth.schematic.client.renderer.DireRenderMethods;
import neoforge.com.hollingsworth.schematic.client.renderer.DireRenderTypes;
import neoforge.com.hollingsworth.schematic.client.renderer.DireVertexConsumer;
import neoforge.com.hollingsworth.schematic.client.renderer.FakeRenderingWorld;
import neoforge.com.hollingsworth.schematic.client.renderer.RenderFluidBlock;
import neoforge.com.hollingsworth.schematic.client.renderer.StatePos;
import neoforge.com.hollingsworth.schematic.client.renderer.StructureRenderData;
import neoforge.com.hollingsworth.schematic.common.util.Color;
import neoforge.com.hollingsworth.schematic.common.util.DimPos;
import neoforge.com.hollingsworth.schematic.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class StructureRenderer {
    public static ArrayList<StructureRenderData> structures = new ArrayList();

    public static void buildRender(StructureRenderData data, PoseStack poseStack, Player player) {
        BlockPos renderPos;
        BlockHitResult lookingAt = RaycastHelper.getLookingAt(data.distanceFromCameraCast, player, true);
        BlockPos blockPos = renderPos = data.anchorPos == null ? lookingAt.getBlockPos() : data.anchorPos;
        if (renderPos == null) {
            return;
        }
        renderPos = renderPos.above();
        DimPos boundTo = new DimPos((ResourceKey<Level>)player.level.dimension(), renderPos);
        if (boundTo != null && boundTo.levelKey().equals((Object)player.level().dimension())) {
            StructureRenderer.drawBoundBox(data, poseStack, boundTo.pos());
        }
        if (StructureRenderer.shouldUpdateRender(data, renderPos = renderPos.above())) {
            StructureRenderer.generateRender(data, player.level(), renderPos, 0.5f);
            data.lastRenderPos = renderPos;
        }
    }

    public static boolean shouldUpdateRender(StructureRenderData data, BlockPos renderPos) {
        return data.lastRenderPos == null || !data.lastRenderPos.equals((Object)renderPos);
    }

    public static void clearByteBuffers(StructureRenderData data) {
        for (Map.Entry<RenderType, ByteBufferBuilder> entry : data.builders.entrySet()) {
            entry.getValue().clear();
        }
        data.bufferBuilders.clear();
        data.sortStates.clear();
        data.meshDatas.clear();
    }

    public static void generateRender(StructureRenderData data, Level level, BlockPos renderPos, float transparency) {
        StructureRenderer.generateRender(data, level, renderPos, transparency, Minecraft.getInstance().gameRenderer.getMainCamera().getPosition());
    }

    public static void generateRender(StructureRenderData data, Level level, BlockPos renderPos, float transparency, Vec3 cameraPosition) {
        BufferBuilder builder;
        ArrayList<StatePos> statePosCache = data.statePosCache;
        Map<RenderType, VertexBuffer> vertexBuffers = data.vertexBuffers;
        if (statePosCache == null || statePosCache.isEmpty()) {
            return;
        }
        data.fakeRenderingWorld = new FakeRenderingWorld(level, statePosCache, renderPos);
        PoseStack matrix = new PoseStack();
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        ModelBlockRenderer modelBlockRenderer = dispatcher.getModelRenderer();
        RandomSource random = RandomSource.create();
        StructureRenderer.clearByteBuffers(data);
        for (StatePos pos : statePosCache) {
            BlockState renderState = data.fakeRenderingWorld.getBlockStateWithoutReal(pos.pos);
            if (renderState.isAir() || !StructureRenderer.isModelRender(pos.state) && pos.state.getFluidState().isEmpty()) continue;
            BakedModel ibakedmodel = dispatcher.getBlockModel(renderState);
            matrix.pushPose();
            matrix.translate((float)pos.pos.getX(), (float)pos.pos.getY(), (float)pos.pos.getZ());
            for (RenderType renderType : Services.PLATFORM.getRenderTypes(ibakedmodel, renderState, random)) {
                if (renderType.equals(RenderType.cutout()) && renderState.getShape((BlockGetter)level, pos.pos.offset((Vec3i)renderPos)).equals(Shapes.block())) {
                    renderType = RenderType.translucent();
                }
                builder = data.bufferBuilders.computeIfAbsent(renderType, rt -> new BufferBuilder(data.getByteBuffer((RenderType)rt), rt.mode(), rt.format()));
                DireVertexConsumer direVertexConsumer = new DireVertexConsumer((VertexConsumer)builder, transparency);
                if (renderState.getFluidState().isEmpty()) {
                    try {
                        modelBlockRenderer.tesselateBlock((BlockAndTintGetter)data.fakeRenderingWorld, ibakedmodel, renderState, pos.pos.offset((Vec3i)renderPos).above(255), matrix, (VertexConsumer)direVertexConsumer, false, random, renderState.getSeed(pos.pos.offset((Vec3i)renderPos)), OverlayTexture.NO_OVERLAY);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                try {
                    RenderFluidBlock.renderFluidBlock(renderState, level, pos.pos.offset((Vec3i)renderPos).above(255), matrix, direVertexConsumer, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            matrix.popPose();
        }
        Vec3 subtracted = cameraPosition.subtract((double)renderPos.getX(), (double)renderPos.getY(), (double)renderPos.getZ());
        Vector3f sortPos = new Vector3f((float)subtracted.x, (float)subtracted.y, (float)subtracted.z);
        for (Map.Entry<RenderType, BufferBuilder> entry : data.bufferBuilders.entrySet()) {
            RenderType renderType = entry.getKey();
            ByteBufferBuilder byteBufferBuilder = data.getByteBuffer(renderType);
            builder = entry.getValue();
            Map<RenderType, MeshData> meshDatas = data.meshDatas;
            if (meshDatas.containsKey(renderType) && meshDatas.get(renderType) != null) {
                meshDatas.get(renderType).close();
            }
            meshDatas.put(renderType, builder.build());
            if (!meshDatas.containsKey(renderType) || meshDatas.get(renderType) == null) continue;
            data.sortStates.put(renderType, meshDatas.get(renderType).sortQuads(byteBufferBuilder, VertexSorting.byDistance(v -> -sortPos.distanceSquared((Vector3fc)v))));
            VertexBuffer vertexBuffer = vertexBuffers.get(entry.getKey());
            vertexBuffer.bind();
            vertexBuffer.upload(meshDatas.get(renderType));
            VertexBuffer.unbind();
        }
    }

    public static void drawBoundBox(StructureRenderData data, PoseStack matrix, BlockPos blockPos) {
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        matrix.pushPose();
        matrix.translate(-projectedView.x(), -projectedView.y(), -projectedView.z());
        Color color = Color.BLUE;
        BoundingBox boundingBox = data.boundingBox;
        if (boundingBox != null) {
            BlockPos min = new BlockPos(boundingBox.minX(), boundingBox.minY(), boundingBox.minZ());
            BlockPos max = new BlockPos(boundingBox.maxX(), boundingBox.maxY(), boundingBox.maxZ());
            min = min.offset((Vec3i)blockPos);
            max = max.offset((Vec3i)blockPos);
            DireRenderMethods.renderCopy(matrix, min, max, color);
        }
        matrix.popPose();
    }

    public static boolean isModelRender(BlockState state) {
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        BakedModel ibakedmodel = dispatcher.getBlockModel(state);
        for (Direction direction : Direction.values()) {
            if (!ibakedmodel.getQuads(state, direction, RandomSource.create()).isEmpty()) {
                return true;
            }
            if (ibakedmodel.getQuads(state, null, RandomSource.create()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static void drawRender(StructureRenderData data, PoseStack poseStack, Matrix4f projectionMatrix, Matrix4f modelViewMatrix, Player player) {
        if (data.vertexBuffers == null) {
            return;
        }
        BlockPos anchorPos = data.anchorPos;
        MultiBufferSource.BufferSource buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        BlockHitResult lookingAt = RaycastHelper.getLookingAt(data.distanceFromCameraCast, player, true);
        BlockPos renderPos = anchorPos == null ? lookingAt.getBlockPos() : anchorPos;
        BlockState lookingAtState = player.level().getBlockState(renderPos);
        if (lookingAtState.isAir() && anchorPos == null) {
            return;
        }
        renderPos = renderPos.above();
        if (data.sortCounter > 20) {
            StructureRenderer.sortAll(data, renderPos);
            data.sortCounter = 0;
        } else {
            ++data.sortCounter;
        }
        PoseStack matrix = poseStack;
        matrix.pushPose();
        matrix.mulPose(modelViewMatrix);
        matrix.translate(-projectedView.x(), -projectedView.y(), -projectedView.z());
        matrix.translate((float)renderPos.getX(), (float)renderPos.getY(), (float)renderPos.getZ());
        ArrayList<RenderType> drawSet = new ArrayList<RenderType>();
        drawSet.add(RenderType.solid());
        drawSet.add(RenderType.cutout());
        drawSet.add(RenderType.cutoutMipped());
        drawSet.add(RenderType.translucent());
        drawSet.add(RenderType.tripwire());
        try {
            for (RenderType renderType : drawSet) {
                RenderType drawRenderType = renderType.equals(RenderType.cutout()) ? DireRenderTypes.RenderBlock : RenderType.translucent();
                VertexBuffer vertexBuffer = data.vertexBuffers.get(renderType);
                if (vertexBuffer.getFormat() == null) continue;
                drawRenderType.setupRenderState();
                vertexBuffer.bind();
                vertexBuffer.drawWithShader(matrix.last().pose(), new Matrix4f((Matrix4fc)projectionMatrix), RenderSystem.getShader());
                VertexBuffer.unbind();
                drawRenderType.clearRenderState();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        matrix.popPose();
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        DireRenderMethods.MultiplyAlphaRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new DireRenderMethods.MultiplyAlphaRenderTypeBuffer((MultiBufferSource)buffersource, 0.5f);
        data.fakeRenderingWorld = new FakeRenderingWorld(player.level(), data.statePosCache, renderPos);
        for (StatePos pos : data.statePosCache) {
            if (pos.state.isAir() || StructureRenderer.isModelRender(pos.state)) continue;
            matrix.pushPose();
            matrix.translate(-projectedView.x(), -projectedView.y(), -projectedView.z());
            matrix.translate((float)renderPos.getX(), (float)renderPos.getY(), (float)renderPos.getZ());
            matrix.translate((float)pos.pos.getX(), (float)pos.pos.getY(), (float)pos.pos.getZ());
            BlockEntityRenderDispatcher blockEntityRenderer = Minecraft.getInstance().getBlockEntityRenderDispatcher();
            BlockEntity blockEntity = data.fakeRenderingWorld.getBlockEntity(pos.pos);
            if (blockEntity != null) {
                blockEntityRenderer.render(blockEntity, 0.0f, matrix, (MultiBufferSource)multiplyAlphaRenderTypeBuffer);
            } else {
                DireRenderMethods.renderBETransparent(data.fakeRenderingWorld.getBlockState(pos.pos), matrix, (MultiBufferSource)buffersource, 0xF00000, 655360, 0.5f);
            }
            matrix.popPose();
        }
    }

    public static void sortAll(StructureRenderData data, BlockPos lookingAt) {
        for (Map.Entry<RenderType, MeshData.SortState> entry : data.sortStates.entrySet()) {
            RenderType renderType = entry.getKey();
            ByteBufferBuilder.Result renderedBuffer = StructureRenderer.sort(data, lookingAt, renderType);
            VertexBuffer vertexBuffer = data.vertexBuffers.get(renderType);
            vertexBuffer.bind();
            vertexBuffer.uploadIndexBuffer(renderedBuffer);
            VertexBuffer.unbind();
        }
    }

    public static ByteBufferBuilder.Result sort(StructureRenderData data, BlockPos lookingAt, RenderType renderType) {
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Vec3 subtracted = projectedView.subtract((double)lookingAt.getX(), (double)lookingAt.getY(), (double)lookingAt.getZ());
        Vector3f sortPos = new Vector3f((float)subtracted.x, (float)subtracted.y, (float)subtracted.z);
        return data.sortStates.get(renderType).buildSortedIndexBuffer(data.getByteBuffer(renderType), VertexSorting.byDistance(v -> -sortPos.distanceSquared((Vector3fc)v)));
    }
}

