/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.common.lib;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import neoforge.com.hollingsworth.schematic.mixin.StructureTemplateAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class BPStructureTemplate
extends StructureTemplate {
    public boolean placeInWorld(ServerLevelAccessor pServerLevel, BlockPos pOffset, BlockPos pPos, StructurePlaceSettings pSettings, RandomSource pRandom, int pFlags) {
        StructureTemplateAccessor accessor = (StructureTemplateAccessor)((Object)this);
        List<StructureTemplate.Palette> palettes = accessor.getPalettes();
        List<StructureTemplate.StructureEntityInfo> entityInfoList = accessor.getEntityInfoList();
        Vec3i size = accessor.getSize();
        if (palettes.isEmpty()) {
            return false;
        }
        List list = pSettings.getRandomPalette(palettes, pOffset).blocks();
        if (!(list.isEmpty() && (pSettings.isIgnoreEntities() || entityInfoList.isEmpty()) || size.getX() < 1 || size.getY() < 1 || size.getZ() < 1)) {
            BoundingBox boundingbox = pSettings.getBoundingBox();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(pSettings.shouldApplyWaterlogging() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)(pSettings.shouldApplyWaterlogging() ? list.size() : 0));
            ArrayList list3 = Lists.newArrayListWithCapacity((int)list.size());
            int i = Integer.MAX_VALUE;
            int j = Integer.MAX_VALUE;
            int k = Integer.MAX_VALUE;
            int l = Integer.MIN_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : BPStructureTemplate.processBlockInfos((ServerLevelAccessor)pServerLevel, (BlockPos)pOffset, (BlockPos)pPos, (StructurePlaceSettings)pSettings, (List)list)) {
                BlockEntity blockentity1;
                BlockPos blockpos = structuretemplate$structureblockinfo.pos();
                if (boundingbox != null && !boundingbox.isInside((Vec3i)blockpos)) continue;
                FluidState fluidstate = pSettings.shouldApplyWaterlogging() ? pServerLevel.getFluidState(blockpos) : null;
                BlockState blockstate = structuretemplate$structureblockinfo.state().mirror(pSettings.getMirror()).rotate(pSettings.getRotation());
                if (structuretemplate$structureblockinfo.nbt() != null) {
                    BlockEntity blockentity = pServerLevel.getBlockEntity(blockpos);
                    Clearable.tryClear((Object)blockentity);
                    pServerLevel.setBlock(blockpos, Blocks.BARRIER.defaultBlockState(), 20);
                }
                if (!pServerLevel.setBlock(blockpos, blockstate, pFlags)) continue;
                i = Math.min(i, blockpos.getX());
                j = Math.min(j, blockpos.getY());
                k = Math.min(k, blockpos.getZ());
                l = Math.max(l, blockpos.getX());
                i1 = Math.max(i1, blockpos.getY());
                j1 = Math.max(j1, blockpos.getZ());
                list3.add(Pair.of((Object)blockpos, (Object)structuretemplate$structureblockinfo.nbt()));
                if (structuretemplate$structureblockinfo.nbt() != null && (blockentity1 = pServerLevel.getBlockEntity(blockpos)) != null) {
                    if (blockentity1 instanceof RandomizableContainer) {
                        structuretemplate$structureblockinfo.nbt().putLong("LootTableSeed", pRandom.nextLong());
                    }
                    try {
                        blockentity1.loadWithComponents(structuretemplate$structureblockinfo.nbt(), (HolderLookup.Provider)pServerLevel.registryAccess());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (fluidstate == null) continue;
                if (blockstate.getFluidState().isSource()) {
                    list2.add(blockpos);
                    continue;
                }
                if (!(blockstate.getBlock() instanceof LiquidBlockContainer)) continue;
                ((LiquidBlockContainer)blockstate.getBlock()).placeLiquid((LevelAccessor)pServerLevel, blockpos, blockstate, fluidstate);
                if (fluidstate.isSource()) continue;
                list1.add(blockpos);
            }
            boolean flag = true;
            Direction[] adirection = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    BlockState blockstate1;
                    Block block;
                    BlockPos blockpos3 = (BlockPos)iterator.next();
                    FluidState fluidstate2 = pServerLevel.getFluidState(blockpos3);
                    for (int i2 = 0; i2 < adirection.length && !fluidstate2.isSource(); ++i2) {
                        BlockPos blockpos1 = blockpos3.relative(adirection[i2]);
                        FluidState fluidstate1 = pServerLevel.getFluidState(blockpos1);
                        if (!fluidstate1.isSource() || list2.contains(blockpos1)) continue;
                        fluidstate2 = fluidstate1;
                    }
                    if (!fluidstate2.isSource() || !((block = (blockstate1 = pServerLevel.getBlockState(blockpos3)).getBlock()) instanceof LiquidBlockContainer)) continue;
                    ((LiquidBlockContainer)block).placeLiquid((LevelAccessor)pServerLevel, blockpos3, blockstate1, fluidstate2);
                    flag = true;
                    iterator.remove();
                }
            }
            if (i <= l) {
                if (!pSettings.getKnownShape()) {
                    BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(l - i + 1, i1 - j + 1, j1 - k + 1);
                    int k1 = i;
                    int l1 = j;
                    int j2 = k;
                    for (Pair pair1 : list3) {
                        BlockPos blockpos2 = (BlockPos)pair1.getFirst();
                        discretevoxelshape.fill(blockpos2.getX() - k1, blockpos2.getY() - l1, blockpos2.getZ() - j2);
                    }
                    BPStructureTemplate.updateShapeAtEdge((LevelAccessor)pServerLevel, (int)pFlags, (DiscreteVoxelShape)discretevoxelshape, (int)k1, (int)l1, (int)j2);
                }
                for (Pair pair : list3) {
                    BlockEntity blockentity2;
                    BlockPos blockpos4 = (BlockPos)pair.getFirst();
                    if (!pSettings.getKnownShape()) {
                        BlockState blockstate3;
                        BlockState blockstate2 = pServerLevel.getBlockState(blockpos4);
                        if (blockstate2 != (blockstate3 = Block.updateFromNeighbourShapes((BlockState)blockstate2, (LevelAccessor)pServerLevel, (BlockPos)blockpos4))) {
                            pServerLevel.setBlock(blockpos4, blockstate3, pFlags & 0xFFFFFFFE | 0x10);
                        }
                        pServerLevel.blockUpdated(blockpos4, blockstate3.getBlock());
                    }
                    if (pair.getSecond() == null || (blockentity2 = pServerLevel.getBlockEntity(blockpos4)) == null) continue;
                    blockentity2.setChanged();
                }
            }
            return true;
        }
        return false;
    }
}

