/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.common.util;

import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;

public class BlockUtil {
    private static final int MAX_DEPTH = 50;

    public static Iterable<BlockPos> iterateAABB(@Nullable AABB pAabb) {
        if (pAabb == null) {
            return List.of();
        }
        return BlockPos.betweenClosed((int)Mth.floor((double)pAabb.minX), (int)Mth.floor((double)pAabb.minY), (int)Mth.floor((double)pAabb.minZ), (int)Mth.floor((double)pAabb.maxX), (int)Mth.floor((double)pAabb.maxY), (int)Mth.floor((double)pAabb.maxZ));
    }

    public static BlockPos findAround(Level world, BlockPos start, int verticalRange, int horizontalRange, BiPredicate<BlockGetter, BlockPos> predicate) {
        if (horizontalRange < 1 && verticalRange < 1) {
            return null;
        }
        if (predicate.test((BlockGetter)world, start)) {
            return start;
        }
        int y = 0;
        int y_offset = 1;
        for (int i = 0; i < verticalRange + 2; ++i) {
            for (int steps = 1; steps <= horizontalRange; ++steps) {
                int z;
                int x;
                BlockPos temp = start.offset(-steps, y, -steps);
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(0, 0, 1))) continue;
                    return temp;
                }
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(-1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(0, 0, -1))) continue;
                    return temp;
                }
            }
            y_offset = y_offset > 0 ? y_offset + 1 : y_offset - 1;
            if (BlockUtil.isInWorldHeight(start.getY() + (y += (y_offset *= -1)), world)) continue;
            return null;
        }
        return null;
    }

    public static int getDimensionMaxHeight(DimensionType dimensionType) {
        return dimensionType.logicalHeight() + dimensionType.minY();
    }

    public static int getDimensionMinHeight(DimensionType dimensionType) {
        return dimensionType.minY();
    }

    public static boolean isInWorldHeight(int yBlock, Level world) {
        DimensionType dimensionType = world.dimensionType();
        return yBlock > BlockUtil.getDimensionMinHeight(dimensionType) && yBlock < BlockUtil.getDimensionMaxHeight(dimensionType);
    }

    public static double boxDistance(AABB box1, AABB box2) {
        double x = Math.max(0.0, Math.max(box1.minX - box2.maxX, box2.minX - box1.maxX));
        double y = Math.max(0.0, Math.max(box1.minY - box2.maxY, box2.minY - box1.maxY));
        double z = Math.max(0.0, Math.max(box1.minZ - box2.maxZ, box2.minZ - box1.maxZ));
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static double distanceBetween(BlockPos blockPos, BlockPos blockPos2) {
        return Math.sqrt(Math.pow(blockPos.getX() - blockPos2.getX(), 2.0) + Math.pow(blockPos.getY() - blockPos2.getY(), 2.0) + Math.pow(blockPos.getZ() - blockPos2.getZ(), 2.0));
    }
}

