/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.common.util;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPInputStream;
import neoforge.com.hollingsworth.schematic.Constants;
import net.minecraft.core.HolderGetter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class FileUtils {
    public static StructureTemplate loadStructureTemplate(HolderGetter<Block> lookup, Path file) {
        StructureTemplate t = new StructureTemplate();
        Path path = file.normalize();
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(Files.newInputStream(path, StandardOpenOption.READ))));){
            CompoundTag nbt = NbtIo.read((DataInput)stream, (NbtAccounter)NbtAccounter.create((long)0x20000000L));
            t.load(lookup, nbt);
        }
        catch (IOException e) {
            Constants.LOG.warn("Failed to read schematic", (Throwable)e);
        }
        return t;
    }
}

