/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.common.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import neoforge.com.hollingsworth.schematic.Constants;
import neoforge.com.hollingsworth.schematic.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class SchematicExport {
    public static final Path SCHEMATICS = Services.PLATFORM.getGameDirectory().resolve("schematics");

    public static StructureTemplate getStructure(Level level, BlockPos first, BlockPos second) {
        BoundingBox bb = BoundingBox.fromCorners((Vec3i)first, (Vec3i)second);
        BlockPos origin = new BlockPos(bb.minX(), bb.minY(), bb.minZ());
        BlockPos bounds = new BlockPos(bb.getXSpan(), bb.getYSpan(), bb.getZSpan());
        StructureTemplate structure = new StructureTemplate();
        structure.fillFromWorld(level, origin, (Vec3i)bounds, true, Blocks.AIR);
        return structure;
    }

    @Nullable
    public static SchematicExportResult saveSchematic(Path dir, String fileName, boolean overwrite, StructureTemplate structure, BlockPos start, BlockPos end) {
        BoundingBox bb = BoundingBox.fromCorners((Vec3i)start, (Vec3i)end);
        BlockPos origin = new BlockPos(bb.minX(), bb.minY(), bb.minZ());
        BlockPos bounds = new BlockPos(bb.getXSpan(), bb.getYSpan(), bb.getZSpan());
        CompoundTag data = structure.save(new CompoundTag());
        String air = "minecraft:air";
        String structureVoid = "minecraft:structure_void";
        data.getList("palette", 10).forEach(inbt -> {
            CompoundTag c = (CompoundTag)inbt;
            if (c.contains("Name") && c.getString("Name").equals(structureVoid)) {
                c.putString("Name", air);
            }
        });
        if (Constants.isCreateLoaded) {
            Services.PLATFORM.appendCreateGlue((Level)Minecraft.getInstance().level, AABB.encapsulatingFullBlocks((BlockPos)origin, (BlockPos)origin.offset((Vec3i)bounds)), data);
        }
        if (((String)fileName).isEmpty()) {
            fileName = "failed_fallback";
        }
        if (!overwrite) {
            fileName = SchematicExport.findFirstValidFilename((String)fileName, dir, "nbt");
        }
        if (!((String)fileName).endsWith(".nbt")) {
            fileName = (String)fileName + ".nbt";
        }
        Path file = dir.resolve((String)fileName).toAbsolutePath();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            boolean overwritten = Files.deleteIfExists(file);
            try (OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE);){
                NbtIo.writeCompressed((CompoundTag)data, (OutputStream)out);
            }
            return new SchematicExportResult(file, dir, (String)fileName, overwritten);
        }
        catch (IOException e) {
            System.out.println("An error occurred while saving schematic [" + (String)fileName + "]");
            return null;
        }
    }

    public static String findFirstValidFilename(String name, Path folderPath, String extension) {
        String filename;
        Path filepath;
        int index = 0;
        do {
            filename = SchematicExport.slug(name) + (String)(index == 0 ? "" : "_" + index) + "." + extension;
            ++index;
        } while (Files.exists(filepath = folderPath.resolve(filename), new LinkOption[0]));
        return filename;
    }

    public static String slug(String name) {
        return name.toLowerCase(Locale.ROOT).replaceAll("\\W+", "_");
    }

    public record SchematicExportResult(Path file, Path dir, String fileName, boolean overwritten) {
    }
}

