/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.export;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.server.packs.resources.ResourceManager;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class OffScreenRenderer
implements AutoCloseable {
    private final NativeImage nativeImage;
    public final TextureTarget fb;
    public final int width;
    public final int height;
    private final AbstractTexture texture = new AbstractTexture(){

        public int getId() {
            return OffScreenRenderer.this.fb.getColorTextureId();
        }

        public void load(ResourceManager resourceManager) throws IOException {
        }
    };

    public OffScreenRenderer(int width, int height) {
        this.width = width;
        this.height = height;
        this.nativeImage = new NativeImage(width, height, true);
        this.fb = new TextureTarget(width, height, true, true);
        this.fb.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.fb.clear(true);
    }

    public AbstractTexture getTexture() {
        return this.texture;
    }

    public void renderToTexture(Runnable r) {
        RenderSystem.viewport((int)0, (int)0, (int)this.width, (int)this.height);
        int currentBuffer = GlStateManager.getBoundFramebuffer();
        this.fb.bindWrite(true);
        GlStateManager._clear((int)16640, (boolean)false);
        r.run();
        this.fb.unbindWrite();
        GlStateManager._glBindFramebuffer((int)36160, (int)currentBuffer);
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft != null) {
            Window window = minecraft.getWindow();
            RenderSystem.viewport((int)0, (int)0, (int)window.getWidth(), (int)window.getHeight());
        }
    }

    @Override
    public void close() {
        this.nativeImage.close();
        this.fb.destroyBuffers();
    }

    public byte[] captureAsPng(Runnable r) {
        this.renderToBuffer(r);
        try {
            return this.nativeImage.asByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to encode image as PNG", e);
        }
    }

    public boolean isAnimated(Collection<TextureAtlasSprite> sprites) {
        return sprites.stream().anyMatch(s -> s.contents().animatedTexture != null);
    }

    private void renderToBuffer(Runnable r) {
        this.fb.bindWrite(true);
        GlStateManager._clear((int)16640, (boolean)false);
        r.run();
        this.fb.unbindWrite();
        this.fb.bindRead();
        this.nativeImage.downloadTexture(0, false);
        this.nativeImage.flipY();
        this.fb.unbindRead();
    }

    private static Matrix4f createViewMatrix(Vector3f eyePos, Vector3f lookAt) {
        Vector3f dir = new Vector3f((Vector3fc)lookAt);
        dir.sub((Vector3fc)eyePos);
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        dir.normalize();
        Vector3f right = new Vector3f((Vector3fc)dir);
        right.cross((Vector3fc)up);
        right.normalize();
        up = new Vector3f((Vector3fc)right);
        up.cross((Vector3fc)dir);
        up.normalize();
        Matrix4f viewMatrix = new Matrix4f();
        viewMatrix.setTransposed(FloatBuffer.wrap(new float[]{right.x(), right.y(), right.z(), 0.0f, up.x(), up.y(), up.z(), 0.0f, -dir.x(), -dir.y(), -dir.z(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}));
        viewMatrix.translate(-eyePos.x(), -eyePos.y(), -eyePos.z());
        return viewMatrix;
    }
}

