/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.export;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import neoforge.com.hollingsworth.schematic.client.renderer.StatePos;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Template {
    public String name;
    public String statePosArrayList;
    public Map<String, Integer> requiredItems = new Object2IntOpenHashMap();
    private static final ImmutableList<Property<?>> DENY_PROPERTIES = ImmutableList.of((Object)BlockStateProperties.AGE_1, (Object)BlockStateProperties.AGE_2, (Object)BlockStateProperties.AGE_3, (Object)BlockStateProperties.AGE_4, (Object)BlockStateProperties.AGE_5, (Object)BlockStateProperties.AGE_7, (Object)BlockStateProperties.AGE_15, (Object)BlockStateProperties.AGE_25, (Object)DoublePlantBlock.HALF, (Object)BlockStateProperties.WATERLOGGED, (Object)BlockStateProperties.LIT, (Object)BlockStateProperties.HAS_RECORD, (Object[])new Property[]{BlockStateProperties.HAS_BOOK, BlockStateProperties.OPEN, BlockStateProperties.STAGE});

    public Template(String name, BlockPos start, BlockPos end) {
        this.name = name;
        ArrayList<StatePos> statePosArrayList = Template.listForDire(start, end, (Level)Minecraft.getInstance().level);
        this.statePosArrayList = Template.statePosListToNBTMapArray(statePosArrayList).toString();
        Map<ItemStackKey, Integer> requiredItemsTemp = StatePos.getItemList(statePosArrayList);
        for (Map.Entry<ItemStackKey, Integer> entry : requiredItemsTemp.entrySet()) {
            if (entry.getKey().getStack().isEmpty()) continue;
            Holder<Item> item = entry.getKey().item;
            ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)((Item)item.value()));
            this.requiredItems.put(registryName.toString(), entry.getValue());
        }
    }

    public String toJson() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)this);
    }

    public static ArrayList<StatePos> listForDire(BlockPos startRaw, BlockPos endRaw, Level level) {
        ArrayList<StatePos> list = new ArrayList<StatePos>();
        AABB area = AABB.encapsulatingFullBlocks((BlockPos)startRaw, (BlockPos)endRaw);
        BlockPos.betweenClosedStream((AABB)area).map(BlockPos::immutable).forEach(pos -> {
            if (Template.validStateForDire(level.getBlockState(pos), level, pos)) {
                list.add(new StatePos(Template.cleanBlockState(level.getBlockState(pos)), pos.subtract((Vec3i)startRaw)));
            } else {
                list.add(new StatePos(Blocks.AIR.defaultBlockState(), pos.subtract((Vec3i)startRaw)));
            }
        });
        return list;
    }

    public static CompoundTag statePosListToNBTMapArray(ArrayList<StatePos> list) {
        CompoundTag tag = new CompoundTag();
        ArrayList<BlockState> blockStateMap = StatePos.getBlockStateMap(list);
        ListTag blockStateMapList = StatePos.getBlockStateNBT(blockStateMap);
        int[] blocklist = new int[list.size()];
        int[] counter = new int[]{0};
        BlockPos start = list.get((int)0).pos;
        BlockPos end = list.get((int)(list.size() - 1)).pos;
        AABB aabb = new AABB(new Vec3((double)start.getX(), (double)start.getY(), (double)start.getZ()), new Vec3((double)end.getX(), (double)end.getY(), (double)end.getZ()));
        Map<BlockPos, BlockState> blockStateByPos = list.stream().collect(Collectors.toMap(e -> e.pos, e -> e.state));
        BlockPos.betweenClosedStream((AABB)aabb).map(BlockPos::immutable).forEach(pos -> {
            BlockState blockState = (BlockState)blockStateByPos.get(pos);
            int n = counter[0];
            counter[0] = n + 1;
            blocklist[n] = blockStateMap.indexOf(blockState);
        });
        tag.put("startpos", NbtUtils.writeBlockPos((BlockPos)start));
        tag.put("endpos", NbtUtils.writeBlockPos((BlockPos)end));
        tag.put("blockstatemap", (Tag)blockStateMapList);
        tag.putIntArray("statelist", blocklist);
        return tag;
    }

    public static BlockState cleanBlockState(BlockState sourceState) {
        BlockState placeState = sourceState.getBlock().defaultBlockState();
        for (Property prop : sourceState.getProperties()) {
            if (DENY_PROPERTIES.contains((Object)prop)) continue;
            placeState = Template.applyProperty(placeState, sourceState, prop);
        }
        return placeState;
    }

    private static <T extends Comparable<T>> BlockState applyProperty(BlockState state, BlockState from, Property<T> prop) {
        return (BlockState)state.setValue(prop, from.getValue(prop));
    }

    public static boolean validStateForDire(BlockState blockState, Level level, BlockPos blockPos) {
        if (blockState.getDestroySpeed((BlockGetter)level, blockPos) < 0.0f) {
            return false;
        }
        return blockState.getFluidState().isEmpty() || blockState.getFluidState().isSource();
    }

    public static ArrayList<StatePos> statePosListFromNBTMapArray(CompoundTag tag) {
        ArrayList<StatePos> statePosList = new ArrayList<StatePos>();
        if (!tag.contains("blockstatemap") || !tag.contains("statelist")) {
            return statePosList;
        }
        ArrayList<BlockState> blockStateMap = StatePos.getBlockStateMapFromNBT(tag.getList("blockstatemap", 10));
        BlockPos start = Template.readBlockPos(tag, "startpos");
        BlockPos end = Template.readBlockPos(tag, "endpos");
        AABB aabb = Template.aabbFromBlockPos(start, end);
        int[] blocklist = tag.getIntArray("statelist");
        int[] counter = new int[]{0};
        BlockPos.betweenClosedStream((AABB)aabb).map(BlockPos::immutable).forEach(pos -> {
            int n = counter[0];
            counter[0] = n + 1;
            int blockStateLookup = blocklist[n];
            BlockState blockState = (BlockState)blockStateMap.get(blockStateLookup);
            statePosList.add(new StatePos(blockState, (BlockPos)pos));
        });
        return statePosList;
    }

    public static BlockPos readBlockPos(CompoundTag compoundTag, String pKey) {
        if (!compoundTag.contains(pKey)) {
            return BlockPos.ZERO;
        }
        CompoundTag tag = compoundTag.getCompound(pKey);
        return new BlockPos(tag.getInt("X"), tag.getInt("Y"), tag.getInt("Z"));
    }

    public static Vec3 blockPosToVec3(BlockPos pos) {
        return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static AABB aabbFromBlockPos(BlockPos start, BlockPos end) {
        return new AABB(Template.blockPosToVec3(start), Template.blockPosToVec3(end));
    }

    public static CompoundTag readCompressed(InputStream pZippedStream, NbtAccounter pAccounter) throws IOException {
        CompoundTag compoundtag;
        try (DataInputStream datainputstream = new DataInputStream((InputStream)new FastBufferedInputStream((InputStream)new GZIPInputStream(pZippedStream)));){
            compoundtag = NbtIo.read((DataInput)datainputstream, (NbtAccounter)pAccounter);
        }
        return compoundtag;
    }

    public static class ItemStackKey {
        public final Holder<Item> item;
        public final DataComponentPatch dataComponents;
        private final int hash;

        public ItemStackKey(ItemStack stack, boolean compareNBT) {
            this.item = stack.getItemHolder();
            this.dataComponents = compareNBT ? stack.getComponentsPatch() : DataComponentPatch.EMPTY;
            this.hash = Objects.hash(this.item, this.dataComponents);
        }

        public ItemStack getStack() {
            return new ItemStack(this.item, 1, this.dataComponents);
        }

        public ItemStack getStack(int amt) {
            return new ItemStack(this.item, amt, this.dataComponents);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemStackKey) {
                return ((ItemStackKey)obj).item == this.item && Objects.equals(((ItemStackKey)obj).dataComponents, this.dataComponents);
            }
            return false;
        }
    }
}

