/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.networking;

import neoforge.com.hollingsworth.schematic.SchematicMod;
import neoforge.com.hollingsworth.schematic.common.lib.BPStructureTemplate;
import neoforge.com.hollingsworth.schematic.networking.AbstractPacket;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class PlaceSchematicPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PlaceSchematicPacket> TYPE = new CustomPacketPayload.Type(SchematicMod.prefix("storage_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlaceSchematicPacket> CODEC = StreamCodec.ofMember(PlaceSchematicPacket::toBytes, PlaceSchematicPacket::new);
    StructureTemplate template;
    StructurePlaceSettings structurePlaceSettings;
    CompoundTag templateTag;
    BlockPos pos;

    public PlaceSchematicPacket(StructureTemplate template, StructurePlaceSettings structurePlaceSettings, BlockPos pos) {
        this.template = template;
        this.structurePlaceSettings = structurePlaceSettings;
        this.pos = pos;
    }

    public PlaceSchematicPacket(RegistryFriendlyByteBuf pb) {
        this.templateTag = (CompoundTag)ByteBufCodecs.TRUSTED_COMPOUND_TAG.decode((Object)pb);
        this.pos = pb.readBlockPos();
        this.structurePlaceSettings = new StructurePlaceSettings();
        this.structurePlaceSettings.setMirror((Mirror)pb.readEnum(Mirror.class));
        this.structurePlaceSettings.setRotation((Rotation)pb.readEnum(Rotation.class));
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf pb) {
        ByteBufCodecs.TRUSTED_COMPOUND_TAG.encode((Object)pb, (Object)this.template.save(new CompoundTag()));
        pb.writeBlockPos(this.pos);
        pb.writeEnum((Enum)this.structurePlaceSettings.getMirror());
        pb.writeEnum((Enum)this.structurePlaceSettings.getRotation());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        if (player.isCreative() || player.hasInfiniteMaterials()) {
            this.template = new BPStructureTemplate();
            this.template.load((HolderGetter)player.level.registryAccess().lookupOrThrow(BuiltInRegistries.BLOCK.key()), this.templateTag);
            this.template.placeInWorld((ServerLevelAccessor)player.serverLevel(), this.pos, this.pos, this.structurePlaceSettings, RandomSource.create((long)Util.getMillis()), 3);
        }
    }
}

