/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.oauth;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import neoforge.com.hollingsworth.schematic.api.blockprints.auth.BlockprintsToken;
import org.jetbrains.annotations.Nullable;

public class TokenLoader {
    public static void writeToken(BlockprintsToken token) {
        try {
            if (token == null || token.tokenExpired()) {
                return;
            }
            Path path = Paths.get(System.getProperty("user.home"), "blockprints", "data.json");
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            JsonObject element = new JsonObject();
            element.addProperty("token", token.token());
            element.addProperty("uuid", token.requesterUUID().toString());
            element.addProperty("expiresAt", (Number)token.tokenExpiresSeconds());
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.writeString(path, (CharSequence)element.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static BlockprintsToken loadToken() {
        try {
            Path path = Paths.get(System.getProperty("user.home"), "blockprints", "data.json");
            if (Files.exists(path, new LinkOption[0])) {
                String content = Files.readString(path, StandardCharsets.UTF_8);
                JsonObject element = JsonParser.parseString((String)content).getAsJsonObject();
                BlockprintsToken token = new BlockprintsToken(element.get("token").getAsString(), element.get("expiresAt").getAsInt(), UUID.fromString(element.get("uuid").getAsString()));
                return token;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

