/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.platform;

import java.nio.file.Path;
import neoforge.com.hollingsworth.schematic.Constants;
import neoforge.com.hollingsworth.schematic.compat.CreateCompat;
import neoforge.com.hollingsworth.schematic.networking.AbstractPacket;
import neoforge.com.hollingsworth.schematic.networking.Networking;
import neoforge.com.hollingsworth.schematic.platform.services.IPlatformHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.model.data.ModelData;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Neoforge";
    }

    @Override
    public Path getGameDirectory() {
        return FMLLoader.getGamePath();
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public Iterable<RenderType> getRenderTypes(BakedModel bakedModel, BlockState blockstate, RandomSource rand) {
        return bakedModel.getRenderTypes(blockstate, rand, ModelData.EMPTY);
    }

    @Override
    public void appendCreateGlue(Level level, AABB aabb, CompoundTag tag) {
        if (Constants.isCreateLoaded) {
            CreateCompat.appendGlue(level, aabb, tag);
        }
    }

    @Override
    public void sendClientToServerPacket(AbstractPacket packet) {
        Networking.sendToServer(packet);
    }

    @Override
    public void sendServerToClientPacket(AbstractPacket packet, ServerPlayer serverPlayer) {
        if (serverPlayer.connection.hasChannel(packet.type())) {
            Networking.sendToPlayerClient(packet, serverPlayer);
        }
    }
}

