/*
 * Decompiled with CFR 0.152.
 */
package com.curseforge.macabre.block;

import com.curseforge.macabre.init.MacabreModBlocks;
import com.curseforge.macabre.procedures.SpineBrainPlantDestroyedByPlayerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpineBrainBlock
extends FlowerBlock {
    public SpineBrainBlock() {
        super(MobEffects.DAMAGE_BOOST, 100.0f, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().sound(SoundType.HONEY_BLOCK).instabreak().lightLevel(s -> 1).noCollission().replaceable().offsetType(BlockBehaviour.OffsetType.NONE).pushReaction(PushReaction.DESTROY));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return Shapes.or((VoxelShape)SpineBrainBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0), (VoxelShape[])new VoxelShape[]{SpineBrainBlock.box((double)5.5, (double)8.6, (double)5.5, (double)10.5, (double)14.6, (double)10.5), SpineBrainBlock.box((double)5.4, (double)3.5, (double)5.4, (double)10.6, (double)9.7, (double)10.6), SpineBrainBlock.box((double)3.5, (double)9.0, (double)8.5, (double)12.5, (double)17.0, (double)13.5), SpineBrainBlock.box((double)3.5, (double)9.0, (double)2.5, (double)12.5, (double)17.0, (double)7.5), SpineBrainBlock.box((double)5.5, (double)1.0, (double)5.5, (double)10.5, (double)7.0, (double)10.5)}).move(offset.x, offset.y, offset.z);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public boolean mayPlaceOn(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        return groundState.is((Block)MacabreModBlocks.SPINE.get());
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)worldIn, blockpos);
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        SpineBrainPlantDestroyedByPlayerProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        return retval;
    }

    public void wasExploded(Level world, BlockPos pos, Explosion e) {
        super.wasExploded(world, pos, e);
        SpineBrainPlantDestroyedByPlayerProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

