/*
 * Decompiled with CFR 0.152.
 */
package com.curseforge.macabre.client.renderer;

import com.curseforge.macabre.client.model.Modelacidpartbig;
import com.curseforge.macabre.entity.ChainswordProjEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ChainswordProjRenderer
extends EntityRenderer<ChainswordProjEntity> {
    private static final ResourceLocation texture = ResourceLocation.parse((String)"macabre:textures/entities/mortempartbig.png");
    private final Modelacidpartbig model;

    public ChainswordProjRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new Modelacidpartbig(context.bakeLayer(Modelacidpartbig.LAYER_LOCATION));
    }

    public void render(ChainswordProjEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer vb = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entityIn)));
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f + Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot())));
        this.model.renderToBuffer(poseStack, vb, packedLightIn, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(ChainswordProjEntity entity) {
        return texture;
    }
}

