/*
 * Decompiled with CFR 0.152.
 */
package com.curseforge.macabre.init;

import com.curseforge.macabre.MacabreMod;
import com.curseforge.macabre.init.MacabreModScreens;
import com.curseforge.macabre.world.inventory.ToothguiMenu;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class MacabreModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"macabre");
    public static final DeferredHolder<MenuType<?>, MenuType<ToothguiMenu>> TOOTHGUI = REGISTRY.register("toothgui", () -> IMenuTypeExtension.create(ToothguiMenu::new));

    public static void setText(String boxname, String value, @Nullable ServerPlayer player) {
        if (player != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new GuiSyncMessage(boxname, value), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new GuiSyncMessage(boxname, value), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MacabreMod.addNetworkMessage(GuiSyncMessage.TYPE, GuiSyncMessage.STREAM_CODEC, GuiSyncMessage::handleData);
    }

    public record GuiSyncMessage(String editbox, String value) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<GuiSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"macabre", (String)"gui_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, GuiSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(buffer, (Object)Component.literal((String)message.editbox));
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(buffer, (Object)Component.literal((String)message.value));
        }, buffer -> {
            String editbox = ((Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(buffer)).getString();
            String value = ((Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(buffer)).getString();
            return new GuiSyncMessage(editbox, value);
        });

        public CustomPacketPayload.Type<GuiSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(GuiSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND) {
                context.enqueueWork(() -> MacabreModScreens.handleTextBoxMessage(message)).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }
}

