/*
 * Decompiled with CFR 0.152.
 */
package com.curseforge.macabre.procedures;

import com.curseforge.macabre.MacabreMod;
import com.curseforge.macabre.entity.GomoriaCloneEntity;
import com.curseforge.macabre.entity.GomoriaEntity;
import com.curseforge.macabre.entity.GomoriaHandProjEntity;
import com.curseforge.macabre.entity.GomoriahandEntity;
import com.curseforge.macabre.entity.HollowEntity;
import com.curseforge.macabre.init.MacabreModEntities;
import com.curseforge.macabre.init.MacabreModMobEffects;
import com.curseforge.macabre.init.MacabreModParticleTypes;
import com.curseforge.macabre.network.MacabreModVariables;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GomoriaOnEntityTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (MacabreModVariables.MapVariables.get((LevelAccessor)world).gomoriaNumber == 1.0) {
            Entity _shootFrom = entity;
            Level projectileLevel = _shootFrom.level();
            if (!projectileLevel.isClientSide()) {
                Projectile _entityToSpawn = new Object(){

                    public Projectile getArrow(Level level, float damage, final int knockback, final byte piercing) {
                        GomoriaHandProjEntity entityToSpawn = new GomoriaHandProjEntity(this, (EntityType)MacabreModEntities.GOMORIA_HAND_PROJ.get(), level){

                            public byte getPierceLevel() {
                                return piercing;
                            }

                            @Override
                            protected void doKnockback(LivingEntity livingEntity, DamageSource damageSource) {
                                if (knockback > 0) {
                                    double d1 = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                                    Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)knockback * 0.6 * d1);
                                    if (vec3.lengthSqr() > 0.0) {
                                        livingEntity.push(vec3.x, 0.1, vec3.z);
                                    }
                                }
                            }
                        };
                        entityToSpawn.setBaseDamage(damage);
                        entityToSpawn.setSilent(true);
                        return entityToSpawn;
                    }
                }.getArrow(projectileLevel, 0.0f, 0, (byte)100);
                _entityToSpawn.setPos(_shootFrom.getX(), _shootFrom.getEyeY() - 0.1, _shootFrom.getZ());
                _entityToSpawn.shoot(_shootFrom.getLookAngle().x, _shootFrom.getLookAngle().y, _shootFrom.getLookAngle().z, 2.0f, 0.0f);
                projectileLevel.addFreshEntity((Entity)_entityToSpawn);
            }
            if (world instanceof Level) {
                Level _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.ravager.roar")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.ravager.roar")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                }
            }
            if (entity instanceof GomoriaEntity) {
                ((GomoriaEntity)entity).setAnimation("attack");
            }
        } else if (MacabreModVariables.MapVariables.get((LevelAccessor)world).gomoriaNumber == 2.0) {
            if (entity.getDirection() == Direction.NORTH) {
                Vec3 _center = new Vec3(x, y, z - 0.3);
                List<Entity> _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(4.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
                for (Entity entityiterator : _entfound) {
                    if (entityiterator instanceof GomoriaHandProjEntity || entityiterator instanceof GomoriahandEntity || entityiterator instanceof GomoriaCloneEntity || entityiterator instanceof HollowEntity || entityiterator instanceof GomoriaEntity) continue;
                    entityiterator.setDeltaMovement(new Vec3(0.0, 3.0, -3.0));
                }
            } else if (entity.getDirection() == Direction.SOUTH) {
                Vec3 _center = new Vec3(x, y, z + 0.3);
                List<Entity> _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(4.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
                for (Entity entityiterator : _entfound) {
                    if (entityiterator instanceof GomoriaHandProjEntity || entityiterator instanceof GomoriahandEntity || entityiterator instanceof GomoriaCloneEntity || entityiterator instanceof HollowEntity || entityiterator instanceof GomoriaEntity) continue;
                    entityiterator.setDeltaMovement(new Vec3(0.0, 3.0, 3.0));
                }
            } else if (entity.getDirection() == Direction.WEST) {
                Vec3 _center = new Vec3(x - 0.3, y, z);
                List<Entity> _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(4.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
                for (Entity entityiterator : _entfound) {
                    if (entityiterator instanceof GomoriaHandProjEntity || entityiterator instanceof GomoriahandEntity || entityiterator instanceof GomoriaCloneEntity || entityiterator instanceof HollowEntity || entityiterator instanceof GomoriaEntity) continue;
                    entityiterator.setDeltaMovement(new Vec3(-3.0, 3.0, 0.0));
                }
            } else if (entity.getDirection() == Direction.EAST) {
                Vec3 _center = new Vec3(x + 0.3, y, z);
                List<Entity> _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(4.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
                for (Entity entityiterator : _entfound) {
                    if (entityiterator instanceof GomoriaHandProjEntity || entityiterator instanceof GomoriahandEntity || entityiterator instanceof GomoriaCloneEntity || entityiterator instanceof HollowEntity || entityiterator instanceof GomoriaEntity) continue;
                    entityiterator.setDeltaMovement(new Vec3(3.0, 3.0, 0.0));
                }
            }
            if (entity instanceof GomoriaEntity) {
                ((GomoriaEntity)entity).setAnimation("attack");
            }
        } else if (MacabreModVariables.MapVariables.get((LevelAccessor)world).gomoriaNumber == 3.0) {
            if (entity instanceof GomoriaEntity) {
                ((GomoriaEntity)entity).setAnimation("attack");
            }
            Vec3 _center = new Vec3(x, y, z);
            List<Entity> _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(8.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
            for (Entity entityiterator : _entfound) {
                LivingEntity _entity;
                if (entityiterator instanceof GomoriaHandProjEntity || entityiterator instanceof GomoriahandEntity || entityiterator instanceof GomoriaCloneEntity || entityiterator instanceof HollowEntity || entityiterator instanceof GomoriaEntity) continue;
                if (entityiterator instanceof LivingEntity && !(_entity = (LivingEntity)entityiterator).level().isClientSide()) {
                    _entity.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 100, 1));
                }
                if (!(entityiterator instanceof LivingEntity) || (_entity = (LivingEntity)entityiterator).level().isClientSide()) continue;
                _entity.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 100, 1));
            }
        } else if (MacabreModVariables.MapVariables.get((LevelAccessor)world).gomoriaNumber == 4.0) {
            if (entity instanceof GomoriaEntity) {
                ((GomoriaEntity)entity).setAnimation("attack");
            }
            Vec3 _center = new Vec3(x, y, z);
            List<Entity> _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(8.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
            for (Entity entityiterator : _entfound) {
                LivingEntity _entity;
                if (entityiterator instanceof GomoriaHandProjEntity || entityiterator instanceof GomoriahandEntity || entityiterator instanceof GomoriaCloneEntity || entityiterator instanceof HollowEntity || entityiterator instanceof GomoriaEntity || !(entityiterator instanceof LivingEntity) || (_entity = (LivingEntity)entityiterator).level().isClientSide()) continue;
                _entity.addEffect(new MobEffectInstance(MacabreModMobEffects.HEMORRHAGE, 300, 1));
            }
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)((SimpleParticleType)MacabreModParticleTypes.GOMORIA_PART.get()), x, y, z, 50, 3.0, 3.0, 3.0, 0.1);
            }
        } else if (MacabreModVariables.MapVariables.get((LevelAccessor)world).gomoriaNumber == 5.0) {
            if (entity instanceof GomoriaEntity) {
                ((GomoriaEntity)entity).setAnimation("attack");
            }
            Vec3 _center = new Vec3(x, y, z);
            List<Entity> _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(8.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
            for (Entity entityiterator : _entfound) {
                LivingEntity _entity;
                if (entityiterator instanceof GomoriaHandProjEntity || entityiterator instanceof GomoriahandEntity || entityiterator instanceof GomoriaCloneEntity || entityiterator instanceof HollowEntity || entityiterator instanceof GomoriaEntity || !(entityiterator instanceof LivingEntity) || (_entity = (LivingEntity)entityiterator).level().isClientSide()) continue;
                _entity.addEffect(new MobEffectInstance(MacabreModMobEffects.DREAD, 180, 1));
            }
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)((SimpleParticleType)MacabreModParticleTypes.MORTEM_AMBIENT.get()), x, y, z, 50, 3.0, 3.0, 3.0, 0.1);
            }
        } else if (MacabreModVariables.MapVariables.get((LevelAccessor)world).gomoriaNumber == 6.0) {
            LivingEntity _entity;
            ServerLevel _level;
            if (entity instanceof GomoriaEntity) {
                ((GomoriaEntity)entity).setAnimation("attack");
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)((SimpleParticleType)MacabreModParticleTypes.GOMORIA_PART.get()), x, y, z, 100, 1.0, 3.0, 1.0, 1.0);
            }
            if (entity instanceof LivingEntity && !(_entity = (LivingEntity)entity).level().isClientSide()) {
                _entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 120, 5, false, false));
            }
            if (entity instanceof LivingEntity && !(_entity = (LivingEntity)entity).level().isClientSide()) {
                _entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 120, 2, false, false));
            }
            if (entity instanceof LivingEntity && !(_entity = (LivingEntity)entity).level().isClientSide()) {
                _entity.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 120, 3, false, false));
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                Entity entityToSpawn = ((EntityType)MacabreModEntities.GOMORIA_CLONE.get()).spawn(_level, BlockPos.containing((double)x, (double)(y + 0.6), (double)z), MobSpawnType.MOB_SUMMONED);
                if (entityToSpawn != null) {
                    // empty if block
                }
            }
            MacabreMod.queueServerWork(120, () -> {
                if (world instanceof ServerLevel) {
                    ServerLevel _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)((SimpleParticleType)MacabreModParticleTypes.MORTEM_AMBIENT.get()), x, y, z, 100, 1.0, 3.0, 1.0, 1.0);
                }
            });
        } else if (MacabreModVariables.MapVariables.get((LevelAccessor)world).gomoriaNumber == 7.0) {
            ServerLevel _level;
            if (entity instanceof GomoriaEntity) {
                ((GomoriaEntity)entity).setAnimation("attack");
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)((SimpleParticleType)MacabreModParticleTypes.MORTEM_AMBIENT.get()), x, y, z, 100, 1.0, 3.0, 1.0, 1.0);
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                Entity entityToSpawn = ((EntityType)MacabreModEntities.HOLLOW.get()).spawn(_level, BlockPos.containing((double)x, (double)(y + 0.6), (double)z), MobSpawnType.MOB_SUMMONED);
                if (entityToSpawn != null) {
                    // empty if block
                }
            }
        }
    }
}

