/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.moredragoneggs;

import com.darkere.moredragoneggs.ServerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;

@Mod(value="moredragoneggs")
public class MoreDragonEggs {
    public static final ServerConfig SERVER_CONFIG = new ServerConfig();

    public MoreDragonEggs(IEventBus ModEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)MoreDragonEggs.SERVER_CONFIG.spec);
    }

    public static void PlaceDragonHead(BlockPos pos, ServerLevel level) {
        if (!SERVER_CONFIG.shouldSpawnHead()) {
            return;
        }
        while (level.getBlockState(pos).getBlock() != Blocks.BEDROCK && pos.getY() > 0) {
            pos = pos.below();
        }
        Player e = level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), -1.0, null);
        Direction dir = e != null ? Direction.getNearest((double)(e.getX() - (double)pos.getX()), (double)0.0, (double)(e.getZ() - (double)pos.getZ())) : Direction.NORTH;
        for (int i = 0; i < 4; ++i) {
            BlockPos headPos = pos.relative(dir);
            if (level.getBlockState(headPos).getBlock() == Blocks.BEDROCK) {
                headPos = headPos.relative(dir);
            }
            if (level.getBlockState(headPos).getBlock() == Blocks.AIR) {
                BlockPos finalHeadPos = headPos;
                Direction finalDir = dir;
                level.getServer().tell((Runnable)new TickTask(0, () -> level.setBlockAndUpdate(finalHeadPos, (BlockState)Blocks.DRAGON_WALL_HEAD.defaultBlockState().setValue((Property)WallSkullBlock.FACING, (Comparable)finalDir))));
                break;
            }
            dir = dir.getClockWise();
        }
    }
}

