/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.module;

import com.yungnickyoung.minecraft.yungsapi.YungsApiNeoForge;
import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterBlock;
import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterItem;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterField;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegistrationManager;
import com.yungnickyoung.minecraft.yungsapi.module.BlockModuleNeoForge;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.RegisterEvent;

public class ItemModuleNeoForge {
    public static void processEntries() {
        YungsApiNeoForge.loadingContextEventBus.addListener(ItemModuleNeoForge::registerItems);
    }

    private static void registerItems(RegisterEvent event) {
        event.register(Registries.ITEM, helper -> {
            AutoRegistrationManager.BLOCKS.forEach(data -> ItemModuleNeoForge.registerBlockItem(data, (RegisterEvent.RegisterHelper<Item>)helper));
            BlockModuleNeoForge.EXTRA_BLOCKS.forEach(extraBlockData -> ItemModuleNeoForge.registerExtraBlockItem(extraBlockData, (RegisterEvent.RegisterHelper<Item>)helper));
            AutoRegistrationManager.ITEMS.stream().filter(data -> !data.processed()).forEach(data -> ItemModuleNeoForge.registerItem(data, (RegisterEvent.RegisterHelper<Item>)helper));
        });
    }

    private static void registerBlockItem(AutoRegisterField data, RegisterEvent.RegisterHelper<Item> helper) {
        AutoRegisterBlock autoRegisterBlock = (AutoRegisterBlock)data.object();
        if (autoRegisterBlock.hasItemProperties()) {
            BlockItem blockItem = new BlockItem((Block)autoRegisterBlock.get(), autoRegisterBlock.getItemProperties().get());
            helper.register(data.name(), (Object)blockItem);
        }
    }

    private static void registerExtraBlockItem(BlockModuleNeoForge.ExtraBlockData extraBlockData, RegisterEvent.RegisterHelper<Item> helper) {
        BlockItem blockItem = new BlockItem(extraBlockData.block(), extraBlockData.itemProperties().get());
        helper.register(extraBlockData.blockRegisteredName(), (Object)blockItem);
    }

    private static void registerItem(AutoRegisterField data, RegisterEvent.RegisterHelper<Item> helper) {
        AutoRegisterItem autoRegisterItem = (AutoRegisterItem)data.object();
        Item item = (Item)autoRegisterItem.get();
        helper.register(data.name(), (Object)item);
        data.markProcessed();
    }
}

