/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs.forms;

import alexthw.not_enough_glyphs.api.spell_style.RayTimeline;
import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import alexthw.not_enough_glyphs.init.ArsNouveauRegistry;
import com.hollingsworth.arsnouveau.api.particle.ParticleEmitter;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.SoundProperty;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineEntryData;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.CastResolveType;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class MethodRay
extends AbstractCastMethod {
    public static final MethodRay INSTANCE = new MethodRay("ray", "Ray");
    public ModConfigSpec.DoubleValue BASE_RANGE;
    public ModConfigSpec.DoubleValue BONUS_RANGE_PER_AUGMENT;

    public MethodRay(String tag, String description) {
        super(CompatRL.tmg(tag), description);
    }

    double getRange(SpellStats stats) {
        return (Double)this.BASE_RANGE.get() + (Double)this.BONUS_RANGE_PER_AUGMENT.get() * stats.getAoeMultiplier();
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.BASE_RANGE = builder.comment("Base range in blocks").defineInRange("base_range", 16.0, 0.0, Double.MAX_VALUE);
        this.BONUS_RANGE_PER_AUGMENT = builder.comment("Bonus range per augment").defineInRange("bonus_range_per_augment", 16.0, 0.0, Double.MAX_VALUE);
    }

    public CastResolveType fireRay(Level world, LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver resolver) {
        Vec3 fromPoint = shooter.getEyePosition(1.0f);
        Vec3 viewVector = shooter.getViewVector(1.0f);
        return this.fireRay(world, shooter, stats, spellContext, resolver, fromPoint, viewVector);
    }

    public CastResolveType fireRay(Level world, LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver resolver, Vec3 fromPoint, Vec3 viewVector) {
        EntityHitResult entityTarget;
        int sensitivity = stats.getBuffCount((AbstractAugment)AugmentSensitive.INSTANCE);
        double range = this.getRange(stats);
        Vec3 toPoint = fromPoint.add(viewVector.scale(range));
        ClipContext rayTraceContext = new ClipContext(fromPoint, toPoint, sensitivity >= 1 ? ClipContext.Block.OUTLINE : ClipContext.Block.COLLIDER, sensitivity >= 2 ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)shooter);
        BlockHitResult blockTarget = world.clip(rayTraceContext);
        if (blockTarget.getType() != HitResult.Type.MISS) {
            double distance = fromPoint.distanceTo(blockTarget.getLocation());
            toPoint = fromPoint.add(viewVector.scale(Math.min(range, distance)));
        }
        if ((entityTarget = ProjectileUtil.getEntityHitResult((Level)world, (Entity)shooter, (Vec3)fromPoint, (Vec3)toPoint, (AABB)new AABB(fromPoint, toPoint).inflate(1.5), e -> e != shooter && e.isAlive() && e instanceof Entity, (float)0.0f)) != null) {
            resolver.onResolveEffect(world, (HitResult)entityTarget);
            Vec3 hitPoint = MethodRay.findNearestPointOnLine(fromPoint, toPoint, entityTarget.getLocation());
            this.send(world, spellContext, fromPoint, hitPoint);
            return CastResolveType.SUCCESS;
        }
        if (blockTarget.getType() == HitResult.Type.BLOCK) {
            resolver.onResolveEffect(world, (HitResult)blockTarget);
            this.send(world, spellContext, fromPoint, blockTarget.getLocation());
            return CastResolveType.SUCCESS;
        }
        if (blockTarget.getType() == HitResult.Type.MISS && sensitivity >= 2) {
            Vec3 approximateNormal = fromPoint.subtract(toPoint).normalize();
            blockTarget = new BlockHitResult(toPoint, Direction.getNearest((double)approximateNormal.x, (double)approximateNormal.y, (double)approximateNormal.z), BlockPos.containing((Position)toPoint), true);
            resolver.onResolveEffect(world, (HitResult)blockTarget);
            this.send(world, spellContext, fromPoint, blockTarget.getLocation());
        } else {
            this.send(world, spellContext, fromPoint, toPoint);
        }
        return CastResolveType.SUCCESS;
    }

    public void playResolveSound(SpellContext spellContext, Level level, Vec3 position) {
        SoundProperty soundProperty = ((RayTimeline)spellContext.getParticleTimeline((IParticleTimelineType)((IParticleTimelineType)ArsNouveauRegistry.RAY_TIMELINE.get()))).resolveSound;
        soundProperty.sound.playSound(level, position.x, position.y, position.z);
    }

    public ParticleEmitter resolveEmitter(SpellContext spellContext, Vec3 position) {
        TimelineEntryData entryData = ((RayTimeline)spellContext.getParticleTimeline((IParticleTimelineType)((IParticleTimelineType)ArsNouveauRegistry.RAY_TIMELINE.get()))).onResolvingEffect;
        return this.createStaticEmitter(entryData, position);
    }

    private void send(Level world, SpellContext spellContext, Vec3 from, Vec3 to) {
        double distance = from.distanceTo(to);
        LivingEntity player = spellContext.getUnwrappedCaster();
        double start = 0.0;
        double increment = 0.5;
        if (player.position().distanceToSqr(from) < 4.0 && to.subtract(from).normalize().dot(player.getViewVector(1.0f)) > (double)(Mth.SQRT_OF_TWO / 2.0f)) {
            start = Math.min(2.0, distance / 2.0);
            increment = 0.25;
        }
        for (double d = start; d < distance; d += increment) {
            double fractionalDistance = d / distance;
            Vec3 position = new Vec3(Mth.lerp((double)fractionalDistance, (double)from.x, (double)to.x), Mth.lerp((double)fractionalDistance, (double)from.y, (double)to.y), Mth.lerp((double)fractionalDistance, (double)from.z, (double)to.z));
            ParticleEmitter particleEmitter = this.resolveEmitter(spellContext, position);
            particleEmitter.tick(world);
        }
        this.playResolveSound(spellContext, world, from);
    }

    @Nonnull
    private static Vec3 findNearestPointOnLine(@Nonnull Vec3 fromPoint, @Nonnull Vec3 toPoint, @Nonnull Vec3 hitPoint) {
        Vec3 u = toPoint.subtract(fromPoint);
        Vec3 pq = hitPoint.subtract(fromPoint);
        Vec3 w2 = pq.subtract(u.scale(pq.dot(u) / u.lengthSqr()));
        return hitPoint.subtract(w2);
    }

    public CastResolveType onCast(@Nullable ItemStack itemStack, LivingEntity shooter, Level world, SpellStats stats, SpellContext spellContext, SpellResolver spellResolver) {
        return this.fireRay(world, shooter, stats, spellContext, spellResolver);
    }

    public CastResolveType onCastOnBlock(UseOnContext itemUseContext, SpellStats stats, SpellContext spellContext, SpellResolver spellResolver) {
        return this.fireRay(itemUseContext.getLevel(), (LivingEntity)itemUseContext.getPlayer(), stats, spellContext, spellResolver);
    }

    public CastResolveType onCastOnBlock(BlockHitResult blockRayTraceResult, LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver spellResolver) {
        return this.fireRay(shooter.level(), shooter, stats, spellContext, spellResolver);
    }

    public CastResolveType onCastOnEntity(@Nullable ItemStack itemStack, LivingEntity shooter, Entity target, InteractionHand hand, SpellStats stats, SpellContext spellContext, SpellResolver spellResolver) {
        return this.fireRay(shooter.level(), shooter, stats, spellContext, spellResolver);
    }

    public int getDefaultManaCost() {
        return 15;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.setOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentSensitive.INSTANCE});
    }

    protected void buildAugmentLimitsConfig(ModConfigSpec.Builder builder, Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentSensitive.INSTANCE.getRegistryName(), 2);
        super.buildAugmentLimitsConfig(builder, defaults);
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentSensitive.INSTANCE, "Sensitive 1 lets the ray strike objects that do not block motion, such as plants or floating Magelight globes. Sensitive 2 allows the ray to strike fluids.");
        map.put((AbstractAugment)AugmentAOE.INSTANCE, "Increases reach.");
    }

    public String getBookDescription() {
        return "Instantaneously strikes the pointed-at target, at limited yet greater range than Touch. Mana is expended whether or not the ray hits anything. AOE increases range. Sensitive 1 lets the ray strike objects that do not block motion, such as plants or floating Magelight globes. Sensitive 2 allows the ray to strike fluids.";
    }

    public Glyph getGlyph() {
        if (this.glyphItem == null) {
            this.glyphItem = new Glyph(this, (AbstractSpellPart)this){

                @NotNull
                public String getCreatorModId(@NotNull ItemStack itemStack) {
                    return "not_enough_glyphs";
                }
            };
        }
        return this.glyphItem;
    }
}

