/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.capability;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.capability.ActiveAbilityData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ActiveAbilityProvider {
    public static final ResourceLocation IDENTIFIER = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"active_ability_data");
    private static final Map<UUID, ActiveAbilityData> playerDataCache = new HashMap<UUID, ActiveAbilityData>();

    public static ActiveAbilityData getActiveAbilityData(Player player) {
        UUID playerId = player.getUUID();
        return playerDataCache.computeIfAbsent(playerId, id -> {
            String dataKey;
            ActiveAbilityData newData = new ActiveAbilityData();
            CompoundTag playerData = player.getPersistentData();
            if (playerData.contains(dataKey = "ars_affinity:active_ability_data")) {
                CompoundTag abilityData = playerData.getCompound(dataKey);
                if (abilityData != null && !abilityData.isEmpty()) {
                    try {
                        newData.deserializeNBT((HolderLookup.Provider)player.level().registryAccess(), abilityData);
                        ArsAffinity.LOGGER.debug("Loaded active ability data for player {}: {}", (Object)player.getName().getString(), (Object)newData.getActiveAbilityType());
                    }
                    catch (Exception e) {
                        ArsAffinity.LOGGER.error("Failed to deserialize active ability data for player {}: {}", (Object)player.getName().getString(), (Object)e.getMessage(), (Object)e);
                    }
                } else {
                    ArsAffinity.LOGGER.debug("Empty active ability data found for player {}", (Object)player.getName().getString());
                }
            } else {
                ArsAffinity.LOGGER.debug("No existing active ability data found for player {}, creating new data", (Object)player.getName().getString());
            }
            return newData;
        });
    }

    public static void loadPlayerData(Player player) {
        ActiveAbilityProvider.getActiveAbilityData(player);
    }

    public static void savePlayerData(Player player) {
        UUID playerId = player.getUUID();
        ActiveAbilityData data = playerDataCache.get(playerId);
        if (data != null && data.isDirty()) {
            CompoundTag playerData = player.getPersistentData();
            String dataKey = "ars_affinity:active_ability_data";
            try {
                CompoundTag abilityData = data.serializeNBT((HolderLookup.Provider)player.level().registryAccess());
                playerData.put(dataKey, (Tag)abilityData);
                data.setDirty(false);
                ArsAffinity.LOGGER.debug("Saved active ability data for player {}: {}", (Object)player.getName().getString(), (Object)data.getActiveAbilityType());
            }
            catch (Exception e) {
                ArsAffinity.LOGGER.error("Failed to serialize active ability data for player {}: {}", (Object)player.getName().getString(), (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public static void saveAllData() {
        ArsAffinity.LOGGER.debug("Saving all active ability data (cache size: {})", (Object)playerDataCache.size());
    }

    public static void clearCache() {
        ArsAffinity.LOGGER.debug("Clearing active ability data cache (size: {})", (Object)playerDataCache.size());
        playerDataCache.clear();
    }

    public static int getCacheSize() {
        return playerDataCache.size();
    }
}

