/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.capability;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.capability.PlayerAffinityData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class PlayerAffinityDataProvider {
    public static final ResourceLocation IDENTIFIER = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"player_affinity_data");
    private static final Map<UUID, PlayerAffinityData> playerDataCache = new HashMap<UUID, PlayerAffinityData>();

    public static PlayerAffinityData getPlayerAffinityData(Player player) {
        UUID playerId = player.getUUID();
        return playerDataCache.computeIfAbsent(playerId, id -> {
            PlayerAffinityData newData = new PlayerAffinityData();
            newData.setPlayer(player);
            CompoundTag playerData = player.getPersistentData();
            String dataKey = "ars_affinity:player_affinity_data";
            if (playerData.contains(dataKey)) {
                CompoundTag affinityData = playerData.getCompound(dataKey);
                if (affinityData != null && !affinityData.isEmpty()) {
                    try {
                        newData.deserializeNBT((HolderLookup.Provider)player.level().registryAccess(), affinityData);
                        ArsAffinity.LOGGER.info("Loaded player affinity data for player {}: {} school points", (Object)player.getName().getString(), (Object)newData.getAllSchoolPoints().size());
                    }
                    catch (Exception e) {
                        ArsAffinity.LOGGER.error("Failed to deserialize player affinity data for player {}: {}", (Object)player.getName().getString(), (Object)e.getMessage(), (Object)e);
                    }
                } else {
                    ArsAffinity.LOGGER.warn("Empty affinity data found for player {}", (Object)player.getName().getString());
                }
            } else {
                ArsAffinity.LOGGER.info("No existing affinity data found for player {}, creating new data", (Object)player.getName().getString());
            }
            return newData;
        });
    }

    public static void loadPlayerData(Player player) {
        PlayerAffinityDataProvider.getPlayerAffinityData(player);
    }

    public static void savePlayerData(Player player) {
        UUID playerId = player.getUUID();
        PlayerAffinityData data = playerDataCache.get(playerId);
        if (data != null) {
            CompoundTag playerData = player.getPersistentData();
            String dataKey = "ars_affinity:player_affinity_data";
            try {
                CompoundTag affinityData = data.serializeNBT((HolderLookup.Provider)player.level().registryAccess());
                playerData.put(dataKey, (Tag)affinityData);
                ArsAffinity.LOGGER.info("Saved player affinity data for player {}: {} school points", (Object)player.getName().getString(), (Object)data.getAllSchoolPoints().size());
            }
            catch (Exception e) {
                ArsAffinity.LOGGER.error("Failed to serialize player affinity data for player {}: {}", (Object)player.getName().getString(), (Object)e.getMessage(), (Object)e);
            }
        } else {
            ArsAffinity.LOGGER.warn("No data found in cache for player {} during save", (Object)player.getName().getString());
        }
    }

    public static void saveAllData() {
        ArsAffinity.LOGGER.info("Saving all player data (cache size: {})", (Object)playerDataCache.size());
    }

    public static void clearCache() {
        ArsAffinity.LOGGER.info("Clearing player data cache (size: {})", (Object)playerDataCache.size());
        playerDataCache.clear();
    }

    public static int getCacheSize() {
        return playerDataCache.size();
    }
}

