/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.client.screen.AffinityScreen;
import com.github.ars_affinity.common.ability.ActiveAbilityPressDownPacket;
import com.github.ars_affinity.common.ability.ActiveAbilityReleasePacket;
import com.github.ars_affinity.common.ability.NetworkHandler;
import com.github.ars_affinity.registry.ParticleRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.Lazy;

public class ArsAffinityClient {
    public static final Lazy<KeyMapping> AFFINITY_UI_KEY = Lazy.of(() -> new KeyMapping("key.ars_affinity.affinity_ui", 91, "key.categories.ars_affinity"));
    public static final Lazy<KeyMapping> ABILITY_KEY = Lazy.of(() -> new KeyMapping("key.ars_affinity.ability", 70, "key.categories.ars_affinity"));

    public static void init(IEventBus modEventBus) {
        ArsAffinity.LOGGER.info("Initializing Ars Affinity client...");
        ParticleRegistry.PARTICLES.register(modEventBus);
        modEventBus.addListener(ArsAffinityClient::clientSetup);
        modEventBus.addListener(ArsAffinityClient::registerKeybindings);
        NeoForge.EVENT_BUS.register(ArsAffinityClient.class);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        ArsAffinity.LOGGER.info("Ars Affinity client setup complete!");
    }

    private static void registerKeybindings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)AFFINITY_UI_KEY.get());
        event.register((KeyMapping)ABILITY_KEY.get());
        ArsAffinity.LOGGER.info("Ars Affinity keybindings registered!");
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Record msg;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null || minecraft.screen != null) {
            return;
        }
        if (((KeyMapping)AFFINITY_UI_KEY.get()).consumeClick()) {
            LocalPlayer player = minecraft.player;
            minecraft.setScreen((Screen)new AffinityScreen((Player)player));
        }
        if (event.getAction() == 1 && event.getKey() == ((KeyMapping)ABILITY_KEY.get()).getKey().getValue()) {
            msg = new ActiveAbilityPressDownPacket();
            NetworkHandler.sendToServer(msg);
        }
        if (event.getAction() == 0 && event.getKey() == ((KeyMapping)ABILITY_KEY.get()).getKey().getValue()) {
            msg = new ActiveAbilityReleasePacket();
            NetworkHandler.sendToServer(msg);
        }
    }
}

