/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.screen.perk;

import com.github.ars_affinity.client.screen.perk.ConnectionType;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;

public class ConnectionStyle {
    private final int color;
    private final int glowColor;
    private final float thickness;
    private final boolean isDashed;
    private final boolean hasGlow;
    private final float glowIntensity;

    public ConnectionStyle(int color, int glowColor, float thickness, boolean isDashed, boolean hasGlow, float glowIntensity) {
        this.color = color;
        this.glowColor = glowColor;
        this.thickness = thickness;
        this.isDashed = isDashed;
        this.hasGlow = hasGlow;
        this.glowIntensity = glowIntensity;
    }

    public static ConnectionStyle forType(ConnectionType type, SpellSchool school) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ConnectionType.AVAILABLE -> new ConnectionStyle(-11900022, 0, 0.5f, true, false, 0.0f);
            case ConnectionType.ACTIVE -> new ConnectionStyle(-9729104, 0, 0.8f, false, false, 0.0f);
            case ConnectionType.LOCKED -> new ConnectionStyle(-12955802, 0, 0.4f, true, false, 0.0f);
            case ConnectionType.PREREQUISITE -> new ConnectionStyle(-10847590, 0, 0.6f, false, false, 0.0f);
        };
    }

    private static int getSchoolColor(SpellSchool school, float alpha) {
        int baseColor = switch (school.getId()) {
            case "elemental_fire" -> -7667712;
            case "elemental_water" -> -16750900;
            case "elemental_earth" -> -7650029;
            case "elemental_air" -> -7876885;
            case "abjuration" -> -7114533;
            case "conjuration" -> -13447886;
            case "manipulation" -> -10496;
            case "necromancy" -> -11861886;
            default -> -7829368;
        };
        int alphaValue = (int)(alpha * 255.0f);
        return alphaValue << 24 | baseColor & 0xFFFFFF;
    }

    public int getColor() {
        return this.color;
    }

    public int getGlowColor() {
        return this.glowColor;
    }

    public float getThickness() {
        return this.thickness;
    }

    public boolean isDashed() {
        return this.isDashed;
    }

    public boolean hasGlow() {
        return this.hasGlow;
    }

    public float getGlowIntensity() {
        return this.glowIntensity;
    }
}

