/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.screen.perk;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public class GalaxyBackgroundRenderer {
    private static final int STAR_COUNT = 150;
    private static final int NEBULA_LAYERS = 2;
    private static final float ANIMATION_SPEED = 0.3f;
    private static final int CACHE_SIZE = 64;
    private static final float CACHE_UPDATE_INTERVAL = 0.1f;
    private final List<Star> stars = new ArrayList<Star>();
    private final List<NebulaLayer> nebulaLayers = new ArrayList<NebulaLayer>();
    private final Random random = new Random(42L);
    private long lastUpdateTime = System.currentTimeMillis();
    private float animationTime;
    private float lastCacheUpdate = 0.0f;
    private final int[][] nebulaCache = new int[2][4096];

    public GalaxyBackgroundRenderer() {
        this.generateStars();
        this.generateNebulaLayers();
    }

    private void generateStars() {
        for (int i = 0; i < 150; ++i) {
            float x = this.random.nextFloat() * 2.0f - 1.0f;
            float y = this.random.nextFloat() * 2.0f - 1.0f;
            float brightness = 0.3f + this.random.nextFloat() * 0.7f;
            float twinkleSpeed = 0.5f + this.random.nextFloat() * 1.5f;
            int color = this.generateStarColor();
            this.stars.add(new Star(x, y, brightness, twinkleSpeed, color));
        }
    }

    private void generateNebulaLayers() {
        for (int i = 0; i < 2; ++i) {
            float intensity = 0.2f + this.random.nextFloat() * 0.4f;
            float speed = 0.1f + this.random.nextFloat() * 0.3f;
            int color1 = this.generateNebulaColor();
            int color2 = this.generateNebulaColor();
            this.nebulaLayers.add(new NebulaLayer(intensity, speed, color1, color2));
        }
    }

    private int generateStarColor() {
        float hue = this.random.nextFloat() * 0.2f + 0.5f;
        float saturation = 0.3f + this.random.nextFloat() * 0.4f;
        float brightness = 0.8f + this.random.nextFloat() * 0.2f;
        return this.hsbToRgb(hue, saturation, brightness);
    }

    private int generateNebulaColor() {
        float hue = this.random.nextFloat() * 0.3f + 0.7f;
        float saturation = 0.4f + this.random.nextFloat() * 0.4f;
        float brightness = 0.2f + this.random.nextFloat() * 0.3f;
        return this.hsbToRgb(hue, saturation, brightness);
    }

    private int hsbToRgb(float h, float s, float b) {
        int r = (int)(Mth.lerp((float)s, (float)1.0f, (float)Mth.clamp((float)(Math.abs(6.0f * h - 3.0f) - 1.0f), (float)0.0f, (float)1.0f)) * 255.0f);
        int g = (int)(Mth.lerp((float)s, (float)1.0f, (float)Mth.clamp((float)(2.0f - Math.abs(6.0f * h - 2.0f)), (float)0.0f, (float)1.0f)) * 255.0f);
        int blue = (int)(Mth.lerp((float)s, (float)1.0f, (float)Mth.clamp((float)(2.0f - Math.abs(6.0f * h - 4.0f)), (float)0.0f, (float)1.0f)) * 255.0f);
        r = (int)((float)r * b);
        g = (int)((float)g * b);
        blue = (int)((float)blue * b);
        return 0xFF000000 | r << 16 | g << 8 | blue;
    }

    public void render(GuiGraphics guiGraphics, int x, int y, int width, int height, float partialTick) {
        this.updateAnimation(partialTick);
        this.renderNebulaLayers(guiGraphics, x, y, width, height);
        this.renderStars(guiGraphics, x, y, width, height);
        this.renderGradientOverlay(guiGraphics, x, y, width, height);
    }

    private void updateAnimation(float partialTick) {
        long currentTime = System.currentTimeMillis();
        float deltaTime = (float)(currentTime - this.lastUpdateTime) / 1000.0f;
        this.lastUpdateTime = currentTime;
        this.animationTime += deltaTime * 0.3f;
    }

    private void renderNebulaLayers(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        if (this.animationTime - this.lastCacheUpdate > 0.1f) {
            this.updateNebulaCache();
            this.lastCacheUpdate = this.animationTime;
        }
        for (int i = 0; i < this.nebulaLayers.size(); ++i) {
            int cacheIndex = 0;
            for (int px = 0; px < width; px += 4) {
                for (int py = 0; py < height; py += 4) {
                    if (cacheIndex >= this.nebulaCache[i].length) continue;
                    int color = this.nebulaCache[i][cacheIndex];
                    if (color != 0) {
                        guiGraphics.fill(px, py, px + 4, py + 4, color);
                    }
                    ++cacheIndex;
                }
            }
        }
    }

    private void updateNebulaCache() {
        for (int i = 0; i < this.nebulaLayers.size(); ++i) {
            NebulaLayer layer = this.nebulaLayers.get(i);
            float offsetX = (float)Math.sin(this.animationTime * layer.speed + (float)i) * 0.1f;
            float offsetY = (float)Math.cos(this.animationTime * layer.speed * 0.7f + (float)i) * 0.1f;
            int cacheIndex = 0;
            for (int px = 0; px < 64; ++px) {
                for (int py = 0; py < 64; ++py) {
                    float normalizedX = (float)px / 64.0f;
                    float normalizedY = (float)py / 64.0f;
                    float distance = (float)Math.sqrt(Math.pow(normalizedX - 0.5f, 2.0) + Math.pow(normalizedY - 0.5f, 2.0)) * 2.0f;
                    if (distance > 1.0f) {
                        this.nebulaCache[i][cacheIndex] = 0;
                    } else {
                        float noiseX = ((float)px + offsetX * 64.0f) / 64.0f;
                        float noiseY = ((float)py + offsetY * 64.0f) / 64.0f;
                        float noise = (float)(Math.sin(noiseX) * Math.cos(noiseY) + Math.sin(noiseX * 2.1f) * Math.cos(noiseY * 2.1f) * 0.5);
                        float intensity = layer.intensity * (1.0f - distance) * (0.5f + noise * 0.5f);
                        if (intensity > 0.1f) {
                            int color = this.blendColors(layer.color1, layer.color2, noise * 0.5f + 0.5f);
                            int alpha = (int)(intensity * 100.0f);
                            this.nebulaCache[i][cacheIndex] = alpha << 24 | color & 0xFFFFFF;
                        } else {
                            this.nebulaCache[i][cacheIndex] = 0;
                        }
                    }
                    ++cacheIndex;
                }
            }
        }
    }

    private void renderStars(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        for (Star star : this.stars) {
            float twinkle = (float)Math.sin(this.animationTime * star.twinkleSpeed) * 0.3f + 0.7f;
            float brightness = star.brightness * twinkle;
            int screenX = (int)((float)x + (star.x + 1.0f) * (float)width / 2.0f);
            int screenY = (int)((float)y + (star.y + 1.0f) * (float)height / 2.0f);
            if (screenX < x || screenX >= x + width || screenY < y || screenY >= y + height) continue;
            int color = (int)(brightness * 255.0f) << 24 | star.color & 0xFFFFFF;
            int size = brightness > 0.8f ? 2 : 1;
            guiGraphics.fill(screenX - size / 2, screenY - size / 2, screenX + size / 2 + 1, screenY + size / 2 + 1, color);
        }
    }

    private void renderGradientOverlay(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int centerX = x + width / 2;
        int centerY = y + height / 2;
        int maxRadius = Math.max(width, height) / 2;
        for (int r = 0; r < maxRadius; r += 2) {
            float alpha = (1.0f - (float)r / (float)maxRadius) * 0.1f;
            int color = (int)(alpha * 255.0f) << 24 | 0;
            for (int angle = 0; angle < 360; angle += 2) {
                double rad = Math.toRadians(angle);
                int px = centerX + (int)(Math.cos(rad) * (double)r);
                int py = centerY + (int)(Math.sin(rad) * (double)r);
                if (px < x || px >= x + width || py < y || py >= y + height) continue;
                guiGraphics.fill(px, py, px + 1, py + 1, color);
            }
        }
    }

    private int blendColors(int color1, int color2, float ratio) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * ratio);
        int g = (int)((float)g1 + (float)(g2 - g1) * ratio);
        int b = (int)((float)b1 + (float)(b2 - b1) * ratio);
        return r << 16 | g << 8 | b;
    }

    private static class Star {
        final float x;
        final float y;
        final float brightness;
        final float twinkleSpeed;
        final int color;

        Star(float x, float y, float brightness, float twinkleSpeed, int color) {
            this.x = x;
            this.y = y;
            this.brightness = brightness;
            this.twinkleSpeed = twinkleSpeed;
            this.color = color;
        }
    }

    private static class NebulaLayer {
        final float intensity;
        final float speed;
        final int color1;
        final int color2;

        NebulaLayer(float intensity, float speed, int color1, int color2) {
            this.intensity = intensity;
            this.speed = speed;
            this.color1 = color1;
            this.color2 = color2;
        }
    }
}

