/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.screen.perk;

import com.github.ars_affinity.perk.PerkNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PerkTreeLayout {
    private static final int NODE_SIZE = 24;
    private static final int COLUMN_SPACING = 80;
    private static final int VERTICAL_SPACING = 40;
    private final Map<String, PerkNode> schoolPerks;
    private final Map<String, NodePosition> nodePositions;
    private final Map<Integer, List<PerkNode>> perksByTier;

    public PerkTreeLayout(Map<String, PerkNode> schoolPerks) {
        this.schoolPerks = schoolPerks;
        this.nodePositions = this.calculateDependencyBasedPositions();
        this.perksByTier = this.groupPerksByTier();
    }

    public Map<Integer, List<PerkNode>> getPerksByTier() {
        return this.perksByTier;
    }

    public int getNodeX(PerkNode node, int startX) {
        NodePosition pos = this.nodePositions.get(node.getId());
        return pos != null ? startX + pos.x : startX;
    }

    public int getNodeY(PerkNode node, int startY) {
        NodePosition pos = this.nodePositions.get(node.getId());
        return pos != null ? startY + pos.y : startY;
    }

    public int getStartX(int width, int scrollX) {
        return width / 2 + scrollX;
    }

    public int getStartY(int scrollY) {
        return 50 + scrollY;
    }

    public int getTreeMinX() {
        return this.nodePositions.values().stream().mapToInt(pos -> pos.x).min().orElse(0) - 12;
    }

    public int getTreeMaxX() {
        return this.nodePositions.values().stream().mapToInt(pos -> pos.x).max().orElse(0) + 12;
    }

    public int getTreeMinY() {
        return this.nodePositions.values().stream().mapToInt(pos -> pos.y).min().orElse(0) - 12;
    }

    public int getTreeMaxY() {
        return this.nodePositions.values().stream().mapToInt(pos -> pos.y).max().orElse(0) + 12;
    }

    public int getTreeWidth() {
        return this.getTreeMaxX() - this.getTreeMinX();
    }

    public int getTreeHeight() {
        return this.getTreeMaxY() - this.getTreeMinY();
    }

    public PerkNode getNodeAt(int mouseX, int mouseY, int startX, int startY) {
        for (Map.Entry<String, NodePosition> entry : this.nodePositions.entrySet()) {
            NodePosition pos = entry.getValue();
            int nodeX = startX + pos.x;
            int nodeY = startY + pos.y;
            if (mouseX < nodeX || mouseX >= nodeX + 24 || mouseY < nodeY || mouseY >= nodeY + 24) continue;
            return this.schoolPerks.get(entry.getKey());
        }
        return null;
    }

    private Map<String, NodePosition> calculateDependencyBasedPositions() {
        int column;
        HashMap<String, NodePosition> positions = new HashMap<String, NodePosition>();
        HashMap<Integer, List> columns = new HashMap<Integer, List>();
        Map<String, Integer> dependencyDepths = this.calculateDependencyDepths();
        for (PerkNode perkNode : this.schoolPerks.values()) {
            column = dependencyDepths.get(perkNode.getId());
            columns.computeIfAbsent(column, k -> new ArrayList()).add(perkNode);
        }
        for (List list : columns.values()) {
            list.sort(Comparator.comparing(PerkNode::getId));
        }
        for (Map.Entry entry : columns.entrySet()) {
            column = (Integer)entry.getKey();
            List nodes = (List)entry.getValue();
            int startY = -(nodes.size() - 1) * 40 / 2;
            for (int i = 0; i < nodes.size(); ++i) {
                PerkNode node = (PerkNode)nodes.get(i);
                int x = column * 80;
                int y = startY + i * 40;
                positions.put(node.getId(), new NodePosition(x, y, column, i));
            }
        }
        return positions;
    }

    private Map<String, Integer> calculateDependencyDepths() {
        HashMap<String, Integer> depths = new HashMap<String, Integer>();
        HashSet<String> processed = new HashSet<String>();
        ArrayList<PerkNode> rootNodes = new ArrayList<PerkNode>();
        for (PerkNode node : this.schoolPerks.values()) {
            if (!node.getPrerequisites().isEmpty()) continue;
            rootNodes.add(node);
        }
        for (PerkNode root : rootNodes) {
            depths.put(root.getId(), 0);
            processed.add(root.getId());
        }
        boolean progressMade = true;
        while (progressMade) {
            progressMade = false;
            for (PerkNode node : this.schoolPerks.values()) {
                if (processed.contains(node.getId())) continue;
                boolean allPrereqsProcessed = true;
                int maxPrereqDepth = -1;
                for (String prereqId : node.getPrerequisites()) {
                    if (!processed.contains(prereqId)) {
                        allPrereqsProcessed = false;
                        break;
                    }
                    Integer prereqDepth = (Integer)depths.get(prereqId);
                    if (prereqDepth == null) continue;
                    maxPrereqDepth = Math.max(maxPrereqDepth, prereqDepth);
                }
                if (!allPrereqsProcessed) continue;
                depths.put(node.getId(), maxPrereqDepth + 1);
                processed.add(node.getId());
                progressMade = true;
            }
        }
        for (PerkNode node : this.schoolPerks.values()) {
            if (depths.containsKey(node.getId())) continue;
            depths.put(node.getId(), 0);
        }
        return depths;
    }

    private Map<Integer, List<PerkNode>> groupPerksByTier() {
        HashMap<Integer, List<PerkNode>> tiers = new HashMap<Integer, List<PerkNode>>();
        for (PerkNode node : this.schoolPerks.values()) {
            tiers.computeIfAbsent(node.getTier(), k -> new ArrayList()).add(node);
        }
        for (List tier : tiers.values()) {
            tier.sort(Comparator.comparing(PerkNode::getId));
        }
        return tiers;
    }

    public static class NodePosition {
        public final int x;
        public final int y;
        public final int column;
        public final int index;

        public NodePosition(int x, int y, int column, int index) {
            this.x = x;
            this.y = y;
            this.column = column;
            this.index = index;
        }
    }
}

