/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.screen.perk;

public class PerkTreeViewport {
    private static final float MIN_ZOOM = 0.3f;
    private static final float MAX_ZOOM = 3.0f;
    private static final float ZOOM_SPEED = 0.1f;
    private static final float PAN_SPEED = 1.0f;
    private float zoom = 1.0f;
    private float viewportX = 0.0f;
    private float viewportY = 0.0f;
    private float targetZoom = 1.0f;
    private float targetX = 0.0f;
    private float targetY = 0.0f;
    private boolean isDragging = false;
    private float lastMouseX = 0.0f;
    private float lastMouseY = 0.0f;

    public void update(float partialTick) {
        float lerpSpeed = 0.1f;
        this.zoom = this.lerp(this.zoom, this.targetZoom, lerpSpeed);
        this.viewportX = this.lerp(this.viewportX, this.targetX, lerpSpeed);
        this.viewportY = this.lerp(this.viewportY, this.targetY, lerpSpeed);
    }

    public void handleMouseWheel(double delta, int mouseX, int mouseY) {
        float zoomFactor = delta > 0.0 ? 1.1f : 0.9f;
        float newZoom = Math.max(0.3f, Math.min(3.0f, this.targetZoom * zoomFactor));
        if (newZoom != this.targetZoom) {
            float mouseWorldX = ((float)mouseX - this.viewportX) / this.targetZoom;
            float mouseWorldY = ((float)mouseY - this.viewportY) / this.targetZoom;
            this.targetZoom = newZoom;
            this.targetX = (float)mouseX - mouseWorldX * this.targetZoom;
            this.targetY = (float)mouseY - mouseWorldY * this.targetZoom;
        }
    }

    public void startDragging(int mouseX, int mouseY) {
        this.isDragging = true;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public void updateDragging(int mouseX, int mouseY) {
        if (this.isDragging) {
            float deltaX = (float)mouseX - this.lastMouseX;
            float deltaY = (float)mouseY - this.lastMouseY;
            this.targetX += deltaX;
            this.targetY += deltaY;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
        }
    }

    public void stopDragging() {
        this.isDragging = false;
    }

    public void centerOnContent(int screenWidth, int screenHeight, int contentWidth, int contentHeight) {
        this.targetX = ((float)screenWidth - (float)contentWidth * this.targetZoom) / 2.0f;
        this.targetY = ((float)screenHeight - (float)contentHeight * this.targetZoom) / 2.0f;
    }

    public void resetView(int screenWidth, int screenHeight) {
        this.targetZoom = 1.0f;
        this.targetX = (float)screenWidth / 2.0f;
        this.targetY = (float)screenHeight / 2.0f;
    }

    public float getZoom() {
        return this.zoom;
    }

    public float getViewportX() {
        return this.viewportX;
    }

    public float getViewportY() {
        return this.viewportY;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public float worldToScreenX(float worldX) {
        return worldX * this.zoom + this.viewportX;
    }

    public float worldToScreenY(float worldY) {
        return worldY * this.zoom + this.viewportY;
    }

    public float screenToWorldX(float screenX) {
        return (screenX - this.viewportX) / this.zoom;
    }

    public float screenToWorldY(float screenY) {
        return (screenY - this.viewportY) / this.zoom;
    }

    private float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }
}

