/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.common.ability;

import com.github.ars_affinity.common.ability.AbstractDashAbility;
import com.github.ars_affinity.perk.AffinityPerk;
import com.github.ars_affinity.registry.ModPotions;
import com.github.ars_affinity.registry.ModSounds;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AirDashHelper
extends AbstractDashAbility {
    private static final AirDashHelper INSTANCE = new AirDashHelper();

    public static void triggerAbility(ServerPlayer player, AffinityPerk.ActiveAbilityPerk perk) {
        INSTANCE.executeAbility(player, perk);
    }

    @Override
    protected Holder<MobEffect> getCooldownEffect() {
        return ModPotions.AIR_DASH_COOLDOWN_EFFECT;
    }

    @Override
    protected void onHitTarget(ServerPlayer player, LivingEntity target, Vec3 startPos, Vec3 endPos, Vec3 dashDir, int index) {
        int delay = Math.min(6, index) * 2;
        this.scheduleTask(player, delay, () -> {
            if (!player.isAlive() || !target.isAlive()) {
                return;
            }
            Level level = player.level();
            if (level.isClientSide()) {
                return;
            }
            Vec3 from = this.computeSideOffset(startPos, endPos, dashDir, target, index);
            Vec3 to = target.getEyePosition();
            Vec3 dir = to.subtract(from).normalize();
            WindCharge wind = new WindCharge(level, from.x, from.y, from.z, dir);
            wind.setOwner((Entity)player);
            wind.setDeltaMovement(dir.scale(3.0));
            level.addFreshEntity((Entity)wind);
        });
    }

    @Override
    protected void spawnTrailParticle(ServerLevel level, double x, double y, double z) {
        level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 1, 0.0, 0.0, 0.0, 0.05);
    }

    @Override
    protected void spawnBurstParticles(ServerLevel level, double x, double y, double z) {
        level.sendParticles((ParticleOptions)ParticleTypes.FIREWORK, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
    }

    @Override
    protected void playSounds(ServerPlayer player) {
        Vec3 pos = player.position();
        player.level().playSound(null, pos.x, pos.y, pos.z, (SoundEvent)ModSounds.DASH.get(), SoundSource.PLAYERS, 0.7f, 1.3f);
    }
}

