/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.common.ritual;

import alexthw.ars_elemental.registry.ModItems;
import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.capability.PlayerAffinityData;
import com.github.ars_affinity.capability.PlayerAffinityDataHelper;
import com.github.ars_affinity.util.ChatMessageHelper;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class RitualAmnesia
extends AbstractRitual {
    protected void tick() {
        Level world = this.getWorld();
        if (world.isClientSide) {
            return;
        }
        if (!this.getContext().isStarted) {
            return;
        }
        SpellSchool targetSchool = this.getTargetSchool();
        if (targetSchool != null) {
            this.resetSpecificSchool(world, targetSchool);
        }
        this.getContext().isDone = true;
    }

    private SpellSchool getTargetSchool() {
        if (this.didConsumeItem((ItemLike)ItemsRegistry.FIRE_ESSENCE.get())) {
            return SpellSchools.ELEMENTAL_FIRE;
        }
        if (this.didConsumeItem((ItemLike)ItemsRegistry.WATER_ESSENCE.get())) {
            return SpellSchools.ELEMENTAL_WATER;
        }
        if (this.didConsumeItem((ItemLike)ItemsRegistry.EARTH_ESSENCE.get())) {
            return SpellSchools.ELEMENTAL_EARTH;
        }
        if (this.didConsumeItem((ItemLike)ItemsRegistry.AIR_ESSENCE.get())) {
            return SpellSchools.ELEMENTAL_AIR;
        }
        if (this.didConsumeItem((ItemLike)ItemsRegistry.ABJURATION_ESSENCE.get())) {
            return SpellSchools.ABJURATION;
        }
        if (this.didConsumeItem((ItemLike)ItemsRegistry.CONJURATION_ESSENCE.get())) {
            return SpellSchools.CONJURATION;
        }
        if (this.didConsumeItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE.get())) {
            return SpellSchools.MANIPULATION;
        }
        if (this.didConsumeItem((ItemLike)ModItems.ANIMA_ESSENCE.get())) {
            return SpellSchools.NECROMANCY;
        }
        return null;
    }

    private void resetSpecificSchool(Level world, SpellSchool school) {
        BlockPos pos = this.getPos();
        if (pos == null) {
            return;
        }
        AABB area = new AABB(pos).inflate(6.0);
        List players = world.getEntitiesOfClass(Player.class, area);
        for (Player player : players) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData(player);
            int pointsToReset = data.getSchoolPoints(school);
            data.setSchoolPoints(school, 0);
            data.resetSchoolPercentage(school);
            data.respecSchool(school);
            PlayerAffinityDataHelper.savePlayerData(player);
            ChatMessageHelper.sendSchoolResetMessage(serverPlayer, school, pointsToReset);
        }
    }

    public boolean canConsumeItem(ItemStack stack) {
        return stack.getItem() == ItemsRegistry.FIRE_ESSENCE.get() || stack.getItem() == ItemsRegistry.WATER_ESSENCE.get() || stack.getItem() == ItemsRegistry.EARTH_ESSENCE.get() || stack.getItem() == ItemsRegistry.AIR_ESSENCE.get() || stack.getItem() == ItemsRegistry.ABJURATION_ESSENCE.get() || stack.getItem() == ItemsRegistry.CONJURATION_ESSENCE.get() || stack.getItem() == ItemsRegistry.MANIPULATION_ESSENCE.get() || stack.getItem() == ModItems.ANIMA_ESSENCE.get();
    }

    public ResourceLocation getRegistryName() {
        return ArsAffinity.prefix("ritual_amnesia");
    }

    public String getDescriptionKey() {
        return "ritual.ars_affinity.amnesia";
    }

    public boolean canStart(Player player) {
        return this.getContext().consumedItems.size() > 0;
    }

    public void modifyTooltips(List<Component> tooltips) {
        tooltips.add((Component)Component.translatable((String)"tooltip.ars_affinity.tablet_of_amnesia"));
        tooltips.add((Component)Component.translatable((String)"tooltip.ars_affinity.tablet_of_amnesia.essence_required"));
    }
}

