/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.datagen;

import com.github.ars_affinity.ArsAffinity;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class CuriosDataGen
implements DataProvider {
    private final PackOutput packOutput;
    private final ExistingFileHelper existingFileHelper;

    public CuriosDataGen(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        this.packOutput = packOutput;
        this.existingFileHelper = existingFileHelper;
    }

    public CompletableFuture<?> run(CachedOutput output) {
        return CompletableFuture.runAsync(() -> {
            this.generateCuriosEntitiesData(output);
            this.generateCuriosSlotsData(output);
        });
    }

    private void generateCuriosEntitiesData(CachedOutput output) {
        JsonObject data = new JsonObject();
        JsonArray entities = new JsonArray();
        entities.add("minecraft:player");
        data.add("entities", (JsonElement)entities);
        JsonArray slots = new JsonArray();
        slots.add("charm");
        data.add("slots", (JsonElement)slots);
        Path dataPath = this.packOutput.getOutputFolder().resolve("data").resolve("ars_affinity").resolve("curios").resolve("entities").resolve("ars_affinity.json");
        try {
            DataProvider.saveStable((CachedOutput)output, (JsonElement)data, (Path)dataPath);
            ArsAffinity.LOGGER.info("Generated curios entities data: {}", (Object)dataPath);
        }
        catch (Exception e) {
            ArsAffinity.LOGGER.error("Failed to save curios entities data: {}", (Object)e.getMessage());
        }
    }

    private void generateCuriosSlotsData(CachedOutput output) {
        JsonObject data = new JsonObject();
        data.addProperty("size", (Number)1);
        data.addProperty("locked", Boolean.valueOf(false));
        data.addProperty("cosmetic", Boolean.valueOf(false));
        data.addProperty("damage_enabled", Boolean.valueOf(false));
        data.addProperty("drop_rule", "default");
        data.addProperty("priority", (Number)0);
        data.addProperty("render", Boolean.valueOf(true));
        data.addProperty("icon", "curios:slot_empty_charm");
        Path dataPath = this.packOutput.getOutputFolder().resolve("data").resolve("ars_affinity").resolve("curios").resolve("slots").resolve("charm.json");
        try {
            DataProvider.saveStable((CachedOutput)output, (JsonElement)data, (Path)dataPath);
            ArsAffinity.LOGGER.info("Generated curios slots data: {}", (Object)dataPath);
        }
        catch (Exception e) {
            ArsAffinity.LOGGER.error("Failed to save curios slots data: {}", (Object)e.getMessage());
        }
    }

    public String getName() {
        return "Ars Affinity Curios Data";
    }
}

