/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.common.network.Networking;
import com.github.ars_affinity.common.network.ParticleEffectPacket;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class ParticleUpdateScheduler {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final ConcurrentHashMap<String, Boolean> activeUpdates = new ConcurrentHashMap();

    public static void startPositionUpdates(Player player, String schoolId) {
        String key = player.getId() + "_" + schoolId;
        activeUpdates.put(key, true);
        scheduler.scheduleAtFixedRate(() -> {
            if (!activeUpdates.getOrDefault(key, false).booleanValue()) {
                return;
            }
            if (player.isRemoved() || !player.isAlive()) {
                activeUpdates.remove(key);
                return;
            }
            MinecraftServer server = player.getServer();
            if (server != null) {
                server.execute(() -> {
                    if (player.isAlive() && !player.isRemoved()) {
                        Vec3 pos = player.position();
                        ParticleEffectPacket updatePacket = new ParticleEffectPacket(player.getId(), schoolId, pos.x, pos.y, pos.z);
                        Networking.sendToNearbyClient(player.level(), player.blockPosition(), (CustomPacketPayload)updatePacket);
                        ArsAffinity.LOGGER.debug("Sent position update for player {}: ({}, {}, {})", (Object)player.getName().getString(), (Object)pos.x, (Object)pos.y, (Object)pos.z);
                    }
                });
            }
        }, 150L, 150L, TimeUnit.MILLISECONDS);
        scheduler.schedule(() -> activeUpdates.remove(key), 3000L, TimeUnit.MILLISECONDS);
    }

    public static void stopPositionUpdates(Player player, String schoolId) {
        String key = player.getId() + "_" + schoolId;
        activeUpdates.remove(key);
    }
}

