/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import com.alexthw.sauce.registry.ModRegistry;
import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.config.ArsAffinityConfig;
import com.github.ars_affinity.perk.AffinityPerkHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.event.SummonEvent;
import com.hollingsworth.arsnouveau.common.entity.IFollowingSummon;
import com.hollingsworth.arsnouveau.common.entity.goal.FollowSummonerGoal;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;

public class PassiveSummoningPowerEvents {
    @SubscribeEvent
    public static void onSummonEvent(SummonEvent event) {
        LivingEntity livingEntity = event.shooter;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (event.world.isClientSide()) {
            return;
        }
        if (event.summon.getLivingEntity() == null) {
            return;
        }
        if (AffinityPerkHelper.hasActivePerk(player, AffinityPerkType.PASSIVE_SUMMONING_POWER)) {
            float amount = AffinityPerkHelper.getPerkAmount(player, AffinityPerkType.PASSIVE_SUMMONING_POWER);
            int time = AffinityPerkHelper.getPerkTime(player, AffinityPerkType.PASSIVE_SUMMONING_POWER);
            int summonPowerBonus = (int)amount;
            PassiveSummoningPowerEvents.applySummonPowerBoostToPlayer(player, summonPowerBonus, time);
            PassiveSummoningPowerEvents.applyExtendedDistanceOverride(event.summon.getLivingEntity(), player, time, event.world);
            ArsAffinity.LOGGER.info("Player {} summoned entity with PASSIVE_SUMMONING_POWER perk (+{} power to player) for {} seconds, with extended distance control", (Object)player.getName().getString(), (Object)summonPowerBonus, (Object)(time / 20));
        }
    }

    private static void applySummonPowerBoostToPlayer(Player player, int powerBonus, int durationTicks) {
        if (player == null) {
            return;
        }
        AttributeInstance attributeInstance = player.getAttribute((Holder)ModRegistry.SUMMON_POWER);
        if (attributeInstance != null) {
            String modifierId = "ars_affinity_summoning_power_boost_" + String.valueOf(player.getUUID());
            attributeInstance.removeModifier(ArsAffinity.prefix(modifierId));
            AttributeModifier modifier = new AttributeModifier(ArsAffinity.prefix(modifierId), (double)powerBonus, AttributeModifier.Operation.ADD_VALUE);
            attributeInstance.addPermanentModifier(modifier);
            if (player.level() instanceof ServerLevel) {
                PowerBoostTimer timer = new PowerBoostTimer(player, durationTicks);
                EventQueue.getServerInstance().addEvent((ITimedEvent)timer);
            }
            ArsAffinity.LOGGER.info("Applied +{} SUMMON_POWER to player {} for {} ticks", (Object)powerBonus, (Object)player.getName().getString(), (Object)durationTicks);
        }
    }

    private static void removePlayerPowerBoost(Player player) {
        if (player == null) {
            return;
        }
        AttributeInstance attributeInstance = player.getAttribute((Holder)ModRegistry.SUMMON_POWER);
        if (attributeInstance != null) {
            String modifierId = "ars_affinity_summoning_power_boost_" + String.valueOf(player.getUUID());
            attributeInstance.removeModifier(ArsAffinity.prefix(modifierId));
            ArsAffinity.LOGGER.info("Removed SUMMON_POWER boost for player {}", (Object)player.getName().getString());
        }
    }

    private static void applyExtendedDistanceOverride(LivingEntity summon, Player player, int durationTicks, Level level) {
        GoalSelector goalSelector;
        if (!(summon instanceof IFollowingSummon)) {
            return;
        }
        IFollowingSummon followingSummon = (IFollowingSummon)summon;
        if (summon instanceof Mob) {
            Mob mob = (Mob)summon;
            v0 = mob.goalSelector;
        } else {
            v0 = goalSelector = null;
        }
        if (goalSelector == null) {
            return;
        }
        goalSelector.getAvailableGoals().removeIf(goal -> goal.getGoal() instanceof FollowSummonerGoal);
        CustomExtendedDistanceGoal extendedGoal = new CustomExtendedDistanceGoal(followingSummon, player, 1.0, ((Double)ArsAffinityConfig.SUMMON_DISTANCE_OVERRIDE_MIN_DISTANCE.get()).floatValue(), ((Double)ArsAffinityConfig.SUMMON_DISTANCE_OVERRIDE_MAX_DISTANCE.get()).floatValue());
        goalSelector.addGoal(2, (Goal)extendedGoal);
        if (level instanceof ServerLevel) {
            DistanceOverrideTimer timer = new DistanceOverrideTimer(goalSelector, extendedGoal, durationTicks);
            EventQueue.getServerInstance().addEvent((ITimedEvent)timer);
        }
    }

    private static class PowerBoostTimer
    implements ITimedEvent {
        private final WeakReference<Player> playerRef;
        private int ticksRemaining;

        public PowerBoostTimer(Player player, int durationTicks) {
            this.playerRef = new WeakReference<Player>(player);
            this.ticksRemaining = durationTicks;
        }

        public void tick(boolean serverSide) {
            if (serverSide) {
                Player player;
                --this.ticksRemaining;
                if (this.ticksRemaining <= 0 && (player = (Player)this.playerRef.get()) != null) {
                    PassiveSummoningPowerEvents.removePlayerPowerBoost(player);
                }
            }
        }

        public boolean isExpired() {
            return this.ticksRemaining <= 0 || this.playerRef.get() == null;
        }
    }

    private static class CustomExtendedDistanceGoal
    extends Goal {
        private final IFollowingSummon summon;
        private final Player owner;
        private final double followSpeed;
        private final float minDist;
        private final float maxDist;
        private int timeToRecalcPath;

        public CustomExtendedDistanceGoal(IFollowingSummon summon, Player owner, double followSpeed, float minDist, float maxDist) {
            this.summon = summon;
            this.owner = owner;
            this.followSpeed = followSpeed;
            this.minDist = minDist;
            this.maxDist = maxDist;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.owner == null || this.owner.isSpectator()) {
                return false;
            }
            return this.summon.getSelfEntity().distanceToSqr((Entity)this.owner) > (double)(this.minDist * this.minDist);
        }

        public boolean canContinueToUse() {
            if (this.owner == null) {
                return false;
            }
            return this.summon.getSelfEntity().distanceToSqr((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
        }

        public void tick() {
            if (this.owner == null) {
                return;
            }
            this.summon.getSelfEntity().getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.summon.getSelfEntity().getMaxHeadXRot());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                float teleportDistance = ((Double)ArsAffinityConfig.SUMMON_DISTANCE_OVERRIDE_TELEPORT_DISTANCE.get()).floatValue();
                if (this.summon.getSelfEntity().distanceToSqr((Entity)this.owner) > (double)(teleportDistance * teleportDistance)) {
                    this.summon.getSelfEntity().moveTo(this.owner.getX(), this.owner.getY(), this.owner.getZ(), this.summon.getSelfEntity().getYRot(), this.summon.getSelfEntity().getXRot());
                    this.summon.getSelfEntity().getNavigation().stop();
                } else {
                    this.summon.getSelfEntity().getNavigation().moveTo((Entity)this.owner, this.followSpeed);
                }
            }
        }
    }

    private static class DistanceOverrideTimer
    implements ITimedEvent {
        private final GoalSelector goalSelector;
        private final Goal customGoal;
        private int ticksRemaining;

        public DistanceOverrideTimer(GoalSelector goalSelector, Goal customGoal, int durationTicks) {
            this.goalSelector = goalSelector;
            this.customGoal = customGoal;
            this.ticksRemaining = durationTicks;
        }

        public void tick(boolean serverSide) {
            if (serverSide) {
                --this.ticksRemaining;
                if (this.ticksRemaining <= 0) {
                    this.revertDistanceOverride();
                }
            }
        }

        public boolean isExpired() {
            return this.ticksRemaining <= 0;
        }

        private void revertDistanceOverride() {
            if (this.goalSelector != null && this.customGoal != null) {
                this.goalSelector.removeGoal(this.customGoal);
                ArsAffinity.LOGGER.info("Reverted distance override for summon");
            }
        }
    }
}

