/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerkHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.hollingsworth.arsnouveau.api.event.EffectResolveEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SpellResolveEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHeal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.neoforged.bus.api.SubscribeEvent;

public class SpellAmplificationEvents {
    private static final Map<UUID, Float> playerHealingAmplification = new HashMap<UUID, Float>();

    @SubscribeEvent
    public static void onSpellCast(SpellCastEvent event) {
        List<AbstractSpellPart> healingEffects;
        IWrappedCaster iWrappedCaster = event.context.getCaster();
        if (!(iWrappedCaster instanceof PlayerCaster)) {
            return;
        }
        PlayerCaster playerCaster = (PlayerCaster)iWrappedCaster;
        Player player = playerCaster.player;
        if (player.level().isClientSide()) {
            return;
        }
        if (AffinityPerkHelper.hasActivePerk(player, AffinityPerkType.PASSIVE_HEALING_AMPLIFICATION) && (healingEffects = event.spell.unsafeList().stream().filter(part -> part instanceof EffectHeal).toList()).size() > 0) {
            float amount = AffinityPerkHelper.getPerkAmount(player, AffinityPerkType.PASSIVE_HEALING_AMPLIFICATION);
            playerHealingAmplification.put(player.getUUID(), Float.valueOf(amount));
            ArsAffinity.LOGGER.info("Player {} cast healing spell with {}% amplification", (Object)player.getName().getString(), (Object)((int)(amount * 100.0f)));
        }
    }

    @SubscribeEvent
    public static void onSpellResolve(SpellResolveEvent.Post event) {
        IWrappedCaster iWrappedCaster = event.context.getCaster();
        if (!(iWrappedCaster instanceof PlayerCaster)) {
            return;
        }
        PlayerCaster playerCaster = (PlayerCaster)iWrappedCaster;
        Player player = playerCaster.player;
        if (player.level().isClientSide()) {
            return;
        }
        playerHealingAmplification.remove(player.getUUID());
    }

    @SubscribeEvent
    public static void onEffectResolve(EffectResolveEvent.Pre event) {
        Float amplification;
        LivingEntity livingEntity = event.shooter;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide()) {
            return;
        }
        if (event.resolveEffect instanceof EffectHeal && (amplification = playerHealingAmplification.get(player.getUUID())) != null) {
            double currentAmp = event.spellStats.getAmpMultiplier();
            double newAmp = currentAmp + (double)amplification.floatValue();
            event.spellStats.setAmpMultiplier(newAmp);
            ArsAffinity.LOGGER.info("Applied {}% healing amplification to EffectHeal for player {}", (Object)((int)(amplification.floatValue() * 100.0f)), (Object)player.getName().getString());
        }
    }

    @SubscribeEvent
    public static void onEffectResolvePost(EffectResolveEvent.Post event) {
        Float amplification;
        LivingEntity livingEntity = event.shooter;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide()) {
            return;
        }
        if (event.resolveEffect instanceof EffectHeal && (amplification = playerHealingAmplification.get(player.getUUID())) != null) {
            float compensation = 2.5f * amplification.floatValue();
            FoodData foodData = player.getFoodData();
            int currentFood = foodData.getFoodLevel();
            int foodGain = Math.round(compensation);
            int newFood = Math.min(20, currentFood + foodGain);
            foodData.setFoodLevel(newFood);
            float currentSaturation = foodData.getSaturationLevel();
            float saturationGain = compensation * 0.5f;
            float newSaturation = Math.min((float)newFood, currentSaturation + saturationGain);
            foodData.setSaturation(newSaturation);
            ArsAffinity.LOGGER.info("Compensated food exhaustion with {} food and {} saturation for player {} due to healing amplification", (Object)foodGain, (Object)Float.valueOf(saturationGain), (Object)player.getName().getString());
        }
    }
}

