/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.mixin;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerk;
import com.github.ars_affinity.perk.AffinityPerkHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public class PlayerPowderedSnowMixin {
    @Inject(method={"setTicksFrozen"}, at={@At(value="HEAD")}, cancellable=true)
    private void setTicksFrozen(int ticks, CallbackInfo ci) {
        AffinityPerk perk;
        Entity entity = (Entity)this;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (ticks > entity.getTicksFrozen() && (perk = AffinityPerkHelper.getAllocatedPerk(player, AffinityPerkType.PASSIVE_COLD_WALKER)) instanceof AffinityPerk.AmountBasedPerk) {
            AffinityPerk.AmountBasedPerk amountPerk = (AffinityPerk.AmountBasedPerk)perk;
            if (amountPerk.amount > 0.0f) {
                ci.cancel();
                ArsAffinity.LOGGER.debug("Player {} has COLD_WALKER perk - preventing frozen tick accumulation", (Object)player.getName().getString());
                return;
            }
        }
    }

    @Inject(method={"makeStuckInBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMakeStuckInBlock(BlockState state, Vec3 motionMultiplier, CallbackInfo ci) {
        AffinityPerk perk;
        Entity entity = (Entity)this;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (state.getBlock() instanceof PowderSnowBlock && (perk = AffinityPerkHelper.getAllocatedPerk(player, AffinityPerkType.PASSIVE_COLD_WALKER)) instanceof AffinityPerk) {
            ci.cancel();
            ArsAffinity.LOGGER.debug("Player {} has COLD_WALKER perk - no slowdown", (Object)player.getName().getString());
            return;
        }
    }
}

