/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.perk;

import com.github.ars_affinity.perk.AffinityPerkType;
import com.github.ars_affinity.perk.PerkCategory;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class PerkNode {
    private final String id;
    private final AffinityPerkType perkType;
    private final SpellSchool school;
    private final int tier;
    private final int pointCost;
    private final List<String> prerequisites;
    private final String prerequisiteGlyph;
    private final PerkCategory category;
    private final float amount;
    private final int time;
    private final int cooldown;
    private final float manaCost;
    private final float damage;
    private final int freezeTime;
    private final float radius;
    private final float dashLength;
    private final float dashDuration;
    private final float health;
    private final float hunger;

    public PerkNode(String id, AffinityPerkType perkType, SpellSchool school, int tier, int pointCost, List<String> prerequisites, String prerequisiteGlyph, PerkCategory category, float amount, int time, int cooldown, float manaCost, float damage, int freezeTime, float radius, float dashLength, float dashDuration, float health, float hunger) {
        this.id = id;
        this.perkType = perkType;
        this.school = school;
        this.tier = tier;
        this.pointCost = pointCost;
        this.prerequisites = prerequisites != null ? new ArrayList<String>(prerequisites) : new ArrayList();
        this.prerequisiteGlyph = prerequisiteGlyph;
        this.category = category;
        this.amount = amount;
        this.time = time;
        this.cooldown = cooldown;
        this.manaCost = manaCost;
        this.damage = damage;
        this.freezeTime = freezeTime;
        this.radius = radius;
        this.dashLength = dashLength;
        this.dashDuration = dashDuration;
        this.health = health;
        this.hunger = hunger;
    }

    public String getId() {
        return this.id;
    }

    public AffinityPerkType getPerkType() {
        return this.perkType;
    }

    public SpellSchool getSchool() {
        return this.school;
    }

    public int getTier() {
        return this.tier;
    }

    public int getPointCost() {
        return this.pointCost;
    }

    public List<String> getPrerequisites() {
        return new ArrayList<String>(this.prerequisites);
    }

    public String getPrerequisiteGlyph() {
        return this.prerequisiteGlyph;
    }

    public PerkCategory getCategory() {
        return this.category;
    }

    public float getAmount() {
        return this.amount;
    }

    public int getTime() {
        return this.time;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public float getManaCost() {
        return this.manaCost;
    }

    public float getDamage() {
        return this.damage;
    }

    public int getFreezeTime() {
        return this.freezeTime;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getDashLength() {
        return this.dashLength;
    }

    public float getDashDuration() {
        return this.dashDuration;
    }

    public float getHealth() {
        return this.health;
    }

    public float getHunger() {
        return this.hunger;
    }

    public boolean hasPrerequisites() {
        return !this.prerequisites.isEmpty();
    }

    public boolean hasPrerequisiteGlyph() {
        return this.prerequisiteGlyph != null && !this.prerequisiteGlyph.isEmpty();
    }

    public boolean isRootNode() {
        return this.prerequisites.isEmpty();
    }

    public String getDisplayName() {
        return "ars_affinity.perk." + this.perkType.name();
    }

    public String getDescription() {
        return "ars_affinity.perk." + this.perkType.name() + ".desc";
    }

    public String getUniqueId() {
        return this.school.getId().toString().toUpperCase().replace(":", "_") + "_" + this.perkType.name() + "_" + this.tier;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("id", this.id);
        tag.putString("perkType", this.perkType.name());
        tag.putString("school", this.school.getId().toString());
        tag.putInt("tier", this.tier);
        tag.putInt("pointCost", this.pointCost);
        tag.putString("prerequisiteGlyph", this.prerequisiteGlyph != null ? this.prerequisiteGlyph : "");
        tag.putString("category", this.category.name());
        tag.putFloat("amount", this.amount);
        tag.putInt("time", this.time);
        tag.putInt("cooldown", this.cooldown);
        tag.putFloat("manaCost", this.manaCost);
        tag.putFloat("damage", this.damage);
        tag.putInt("freezeTime", this.freezeTime);
        tag.putFloat("radius", this.radius);
        tag.putFloat("dashLength", this.dashLength);
        tag.putFloat("dashDuration", this.dashDuration);
        tag.putFloat("health", this.health);
        tag.putFloat("hunger", this.hunger);
        ListTag prerequisitesTag = new ListTag();
        for (String prerequisite : this.prerequisites) {
            prerequisitesTag.add((Object)StringTag.valueOf((String)prerequisite));
        }
        tag.put("prerequisites", (Tag)prerequisitesTag);
        return tag;
    }

    public static PerkNode deserializeNBT(CompoundTag tag) {
        String id = tag.getString("id");
        AffinityPerkType perkType = AffinityPerkType.valueOf(tag.getString("perkType"));
        SpellSchool school = PerkNode.parseSpellSchool(tag.getString("school"));
        int tier = tag.getInt("tier");
        int pointCost = tag.getInt("pointCost");
        String prerequisiteGlyph = tag.getString("prerequisiteGlyph");
        if (prerequisiteGlyph.isEmpty()) {
            prerequisiteGlyph = null;
        }
        PerkCategory category = PerkCategory.valueOf(tag.getString("category"));
        float amount = tag.getFloat("amount");
        int time = tag.getInt("time");
        int cooldown = tag.getInt("cooldown");
        float manaCost = tag.getFloat("manaCost");
        float damage = tag.getFloat("damage");
        int freezeTime = tag.getInt("freezeTime");
        float radius = tag.getFloat("radius");
        float dashLength = tag.getFloat("dashLength");
        float dashDuration = tag.getFloat("dashDuration");
        float health = tag.getFloat("health");
        float hunger = tag.getFloat("hunger");
        ArrayList<String> prerequisites = new ArrayList<String>();
        ListTag prerequisitesTag = tag.getList("prerequisites", 8);
        for (Tag prerequisiteTag : prerequisitesTag) {
            if (!(prerequisiteTag instanceof StringTag)) continue;
            StringTag stringTag = (StringTag)prerequisiteTag;
            prerequisites.add(stringTag.getAsString());
        }
        return new PerkNode(id, perkType, school, tier, pointCost, prerequisites, prerequisiteGlyph, category, amount, time, cooldown, manaCost, damage, freezeTime, radius, dashLength, dashDuration, health, hunger);
    }

    private static SpellSchool parseSpellSchool(String schoolId) {
        return switch (schoolId) {
            case "ars_nouveau:elemental_fire" -> SpellSchools.ELEMENTAL_FIRE;
            case "ars_nouveau:elemental_water" -> SpellSchools.ELEMENTAL_WATER;
            case "ars_nouveau:elemental_earth" -> SpellSchools.ELEMENTAL_EARTH;
            case "ars_nouveau:elemental_air" -> SpellSchools.ELEMENTAL_AIR;
            case "ars_nouveau:abjuration" -> SpellSchools.ABJURATION;
            case "ars_nouveau:necromancy" -> SpellSchools.NECROMANCY;
            case "ars_nouveau:conjuration" -> SpellSchools.CONJURATION;
            case "ars_nouveau:manipulation" -> SpellSchools.MANIPULATION;
            default -> throw new IllegalArgumentException("Unknown spell school: " + schoolId);
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PerkNode perkNode = (PerkNode)obj;
        return this.id.equals(perkNode.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "PerkNode{id='" + this.id + "', perkType=" + String.valueOf((Object)this.perkType) + ", school=" + this.school.getId() + ", tier=" + this.tier + ", pointCost=" + this.pointCost + ", category=" + String.valueOf((Object)this.category) + ", amount=" + this.amount + "}";
    }
}

