/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.perk;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerk;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.github.ars_affinity.perk.PerkData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PerkRegistry {
    private static final Map<String, PerkData> PERK_REGISTRY = new HashMap<String, PerkData>();
    private static final int MAX_TIER = 3;
    private static final Gson GSON = new GsonBuilder().create();
    private static final SpellSchool[] SUPPORTED_SCHOOLS = new SpellSchool[]{SpellSchools.ELEMENTAL_FIRE, SpellSchools.ELEMENTAL_WATER, SpellSchools.ELEMENTAL_EARTH, SpellSchools.ELEMENTAL_AIR, SpellSchools.ABJURATION, SpellSchools.NECROMANCY, SpellSchools.CONJURATION, SpellSchools.MANIPULATION};

    public static void initializeFromConfig() {
        PERK_REGISTRY.clear();
        Path configDir = Path.of("config", "ars_affinity", "perks");
        ArsAffinity.LOGGER.info("Looking for perk configs in: {}", (Object)configDir.toAbsolutePath());
        try {
            if (!Files.exists(configDir, new LinkOption[0])) {
                ArsAffinity.LOGGER.warn("Perk config directory does not exist: {}", (Object)configDir);
                return;
            }
            try (Stream<Path> schoolPaths = Files.list(configDir);){
                List schoolDirs = schoolPaths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
                ArsAffinity.LOGGER.info("Found {} school directories: {}", (Object)schoolDirs.size(), (Object)schoolDirs.stream().map(path -> path.getFileName().toString()).collect(Collectors.joining(", ")));
                for (Path schoolDir : schoolDirs) {
                    String schoolName = schoolDir.getFileName().toString().toUpperCase();
                    ArsAffinity.LOGGER.info("Processing school directory: {}", (Object)schoolName);
                    Stream<Path> tierPaths = Files.list(schoolDir);
                    try {
                        List tierDirs = tierPaths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
                        ArsAffinity.LOGGER.info("Found {} tier directories in {}: {}", (Object)tierDirs.size(), (Object)schoolName, (Object)tierDirs.stream().map(path -> path.getFileName().toString()).collect(Collectors.joining(", ")));
                        for (Path tierDir : tierDirs) {
                            String tierName = tierDir.getFileName().toString();
                            ArsAffinity.LOGGER.info("Processing tier directory: {} for school {}", (Object)tierName, (Object)schoolName);
                            try {
                                int tier = Integer.parseInt(tierName);
                                Stream<Path> jsonPaths = Files.list(tierDir);
                                try {
                                    List jsonFiles = jsonPaths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).collect(Collectors.toList());
                                    ArsAffinity.LOGGER.info("Found {} JSON files in {}_{}: {}", (Object)jsonFiles.size(), (Object)schoolName, (Object)tier, (Object)jsonFiles.stream().map(path -> path.getFileName().toString()).collect(Collectors.joining(", ")));
                                    for (Path jsonFile : jsonFiles) {
                                        try {
                                            ArsAffinity.LOGGER.info("Processing config file: {} for {}_{}", (Object)jsonFile, (Object)schoolName, (Object)tier);
                                            PerkRegistry.loadPerkFileFromSchoolTier(schoolName, tier, jsonFile);
                                        }
                                        catch (Exception e) {
                                            ArsAffinity.LOGGER.error("Failed to load perk file: {} - {}", (Object)jsonFile, (Object)e.getMessage());
                                        }
                                    }
                                }
                                finally {
                                    if (jsonPaths == null) continue;
                                    jsonPaths.close();
                                }
                            }
                            catch (NumberFormatException e) {
                                ArsAffinity.LOGGER.warn("Invalid tier directory name: {}", (Object)tierName);
                            }
                        }
                    }
                    finally {
                        if (tierPaths == null) continue;
                        tierPaths.close();
                    }
                }
            }
            ArsAffinity.LOGGER.info("PerkRegistry initialized with {} perk configurations", (Object)PERK_REGISTRY.size());
        }
        catch (Exception e) {
            ArsAffinity.LOGGER.error("Error loading perk configs: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void loadPerkFileFromSchoolTier(String schoolName, int tier, Path jsonFile) throws IOException {
        String content = Files.readString(jsonFile);
        ArsAffinity.LOGGER.info("Loading perk file: {} for school {} tier {}", (Object)jsonFile.getFileName(), (Object)schoolName, (Object)tier);
        try {
            JsonArray perksArray = JsonParser.parseString((String)content).getAsJsonArray();
            for (JsonElement perkElement : perksArray) {
                JsonObject perkObject = perkElement.getAsJsonObject();
                String perkTypeStr = perkObject.get("perk").getAsString();
                String perkKey = String.format("%s_%s_%d", schoolName, perkTypeStr, tier);
                ArsAffinity.LOGGER.info("Registering perk: {} -> {}", (Object)perkKey, (Object)perkObject);
                try {
                    JsonDeserializationContext context = new JsonDeserializationContext(){

                        public <T> T deserialize(JsonElement json, Type typeOfT) {
                            return (T)GSON.fromJson(json, typeOfT);
                        }
                    };
                    AffinityPerk affinityPerk = AffinityPerk.fromJson(perkElement, context);
                    SpellSchool school = PerkRegistry.parseSpellSchool(schoolName.toLowerCase());
                    if (school != null) {
                        PerkData data = new PerkData(affinityPerk, school, tier);
                        PERK_REGISTRY.put(perkKey, data);
                        continue;
                    }
                    ArsAffinity.LOGGER.warn("Unknown school: {} for perk {}", (Object)schoolName, (Object)perkKey);
                }
                catch (Exception e) {
                    ArsAffinity.LOGGER.error("Failed to create AffinityPerk from JSON: {} - {}", (Object)perkObject, (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            ArsAffinity.LOGGER.error("Failed to parse perk file: {} - {}", (Object)jsonFile, (Object)e.getMessage());
            throw e;
        }
    }

    private static void loadPerkFile(Path configDir, Path jsonFile) throws IOException {
        ArsAffinity.LOGGER.warn("loadPerkFile is deprecated, use loadPerkFileFromSchoolTier instead");
    }

    private static SpellSchool parseSpellSchool(String schoolName) {
        return switch (schoolName.toLowerCase()) {
            case "fire" -> SpellSchools.ELEMENTAL_FIRE;
            case "water" -> SpellSchools.ELEMENTAL_WATER;
            case "earth" -> SpellSchools.ELEMENTAL_EARTH;
            case "air" -> SpellSchools.ELEMENTAL_AIR;
            case "abjuration" -> SpellSchools.ABJURATION;
            case "conjuration" -> SpellSchools.CONJURATION;
            case "necromancy" -> SpellSchools.NECROMANCY;
            case "manipulation" -> SpellSchools.MANIPULATION;
            default -> null;
        };
    }

    private static String generateKey(SpellSchool school, AffinityPerkType perkType, int tier) {
        return String.format("%s_%s_%d", school.getId().toString().toUpperCase().replace(":", "_"), perkType.name(), tier);
    }

    public static PerkData getPerk(String key) {
        return PERK_REGISTRY.get(key);
    }

    public static PerkData getPerk(SpellSchool school, AffinityPerkType perkType, int tier) {
        String key = PerkRegistry.generateKey(school, perkType, tier);
        return PERK_REGISTRY.get(key);
    }

    public static boolean hasPerk(String key) {
        return PERK_REGISTRY.containsKey(key);
    }

    public static Set<String> getAllPerkKeys() {
        return new HashSet<String>(PERK_REGISTRY.keySet());
    }

    public static int getTotalPerkCount() {
        return PERK_REGISTRY.size();
    }
}

