/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.potion;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerk;
import com.github.ars_affinity.perk.AffinityPerkManager;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;

public class HydratedEffect
extends MobEffect {
    public HydratedEffect() {
        super(MobEffectCategory.BENEFICIAL, 8900331);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            FoodData foodData = player.getFoodData();
            int countdownTicks = this.getCountdownFromPerks(amplifier);
            if (player.tickCount % countdownTicks == 0 && foodData.getFoodLevel() < 20) {
                int oldFood = foodData.getFoodLevel();
                foodData.setFoodLevel(foodData.getFoodLevel() + 1);
                ArsAffinity.LOGGER.info("HYDRATION - Hydrated {} effect tick for player: {} - restored hunger: {} -> {} (every {} ticks)", (Object)(amplifier + 1), (Object)player.getName().getString(), (Object)oldFood, (Object)foodData.getFoodLevel(), (Object)countdownTicks);
            }
        }
        return true;
    }

    private int getCountdownFromPerks(int amplifier) {
        int tier = amplifier + 1;
        AffinityPerk perk = AffinityPerkManager.getPerk(SpellSchools.ELEMENTAL_WATER, tier, AffinityPerkType.PASSIVE_HYDRATION);
        if (perk instanceof AffinityPerk.DurationBasedPerk) {
            AffinityPerk.DurationBasedPerk durationPerk = (AffinityPerk.DurationBasedPerk)perk;
            return durationPerk.time;
        }
        return 600;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean isBeneficial() {
        return true;
    }

    public String getDescriptionId() {
        return "effect.ars_affinity.hydrated";
    }
}

