/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.util;

import com.github.ars_affinity.ArsAffinity;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class ChatMessageHelper {
    private ChatMessageHelper() {
    }

    public static void sendSchoolResetMessage(ServerPlayer player, SpellSchool school, int pointsReset) {
        String schoolName = ChatMessageHelper.formatSchoolName(school);
        MutableComponent message = Component.literal((String)String.format("\u00a7aReset %s affinity to 0 points (removed %d points)", schoolName, pointsReset));
        player.sendSystemMessage((Component)message);
        ArsAffinity.LOGGER.info("Player {} reset {} affinity (removed {} points)", (Object)player.getName().getString(), (Object)schoolName, (Object)pointsReset);
    }

    public static void sendAllSchoolsResetMessage(ServerPlayer player, int totalPointsReset) {
        MutableComponent message = Component.literal((String)String.format("\u00a7aReset all affinities to 0 points (removed %d total points)", totalPointsReset));
        player.sendSystemMessage((Component)message);
        ArsAffinity.LOGGER.info("Player {} reset all affinities (removed {} total points)", (Object)player.getName().getString(), (Object)totalPointsReset);
    }

    public static void sendSchoolResetFailureMessage(ServerPlayer player, SpellSchool school, String reason) {
        String schoolName = ChatMessageHelper.formatSchoolName(school);
        MutableComponent message = Component.literal((String)String.format("\u00a7cFailed to reset %s affinity: %s", schoolName, reason));
        player.sendSystemMessage((Component)message);
    }

    public static void sendAllSchoolsResetFailureMessage(ServerPlayer player, String reason) {
        MutableComponent message = Component.literal((String)String.format("\u00a7cFailed to reset all affinities: %s", reason));
        player.sendSystemMessage((Component)message);
    }

    private static String formatSchoolName(SpellSchool school) {
        return school.getId().toString().replace("ars_nouveau:", "").replace("_", " ").toLowerCase();
    }
}

