/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.util;

import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import java.util.HashMap;
import java.util.Map;

public class SchoolColors {
    private static final Map<SpellSchool, ParticleColor> PARTICLE_COLORS = new HashMap<SpellSchool, ParticleColor>();
    private static final Map<SpellSchool, Integer> HEX_COLORS = new HashMap<SpellSchool, Integer>();

    public static ParticleColor getParticleColor(SpellSchool school) {
        return PARTICLE_COLORS.getOrDefault(school, new ParticleColor(255, 255, 255));
    }

    public static int getHexColor(SpellSchool school) {
        return HEX_COLORS.getOrDefault(school, -1);
    }

    public static int getRed(SpellSchool school) {
        ParticleColor color = SchoolColors.getParticleColor(school);
        return (int)color.getRed();
    }

    public static int getGreen(SpellSchool school) {
        ParticleColor color = SchoolColors.getParticleColor(school);
        return (int)color.getGreen();
    }

    public static int getBlue(SpellSchool school) {
        ParticleColor color = SchoolColors.getParticleColor(school);
        return (int)color.getBlue();
    }

    static {
        PARTICLE_COLORS.put(SpellSchools.ELEMENTAL_FIRE, new ParticleColor(255, 255, 255));
        PARTICLE_COLORS.put(SpellSchools.ELEMENTAL_WATER, new ParticleColor(130, 162, 237));
        PARTICLE_COLORS.put(SpellSchools.ELEMENTAL_EARTH, new ParticleColor(98, 226, 150));
        PARTICLE_COLORS.put(SpellSchools.ELEMENTAL_AIR, new ParticleColor(212, 207, 90));
        PARTICLE_COLORS.put(SpellSchools.MANIPULATION, new ParticleColor(255, 136, 0));
        PARTICLE_COLORS.put(SpellSchools.ABJURATION, new ParticleColor(235, 124, 206));
        PARTICLE_COLORS.put(SpellSchools.NECROMANCY, new ParticleColor(227, 227, 227));
        PARTICLE_COLORS.put(SpellSchools.CONJURATION, new ParticleColor(106, 227, 206));
        HEX_COLORS.put(SpellSchools.ELEMENTAL_FIRE, -1022362);
        HEX_COLORS.put(SpellSchools.ELEMENTAL_WATER, -8215827);
        HEX_COLORS.put(SpellSchools.ELEMENTAL_EARTH, -10296682);
        HEX_COLORS.put(SpellSchools.ELEMENTAL_AIR, -2830502);
        HEX_COLORS.put(SpellSchools.MANIPULATION, -30720);
        HEX_COLORS.put(SpellSchools.ABJURATION, -1344306);
        HEX_COLORS.put(SpellSchools.NECROMANCY, -1842205);
        HEX_COLORS.put(SpellSchools.CONJURATION, -9772082);
    }
}

