/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.block;

import net.mcreator.astraldimension.procedures.AstraniteCageBlockDestroyedByPlayerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AstraniteCageBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public AstraniteCageBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).sound(SoundType.METAL).strength(5.0f, 20.0f).lightLevel(s -> 15).noOcclusion().pushReaction(PushReaction.IGNORE).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)AstraniteCageBlock.box((double)-1.0, (double)0.0, (double)-1.0, (double)17.0, (double)32.0, (double)17.0), (VoxelShape)AstraniteCageBlock.box((double)4.0, (double)20.0, (double)17.0, (double)12.0, (double)30.0, (double)19.0));
            case Direction.NORTH -> Shapes.or((VoxelShape)AstraniteCageBlock.box((double)-1.0, (double)0.0, (double)-1.0, (double)17.0, (double)32.0, (double)17.0), (VoxelShape)AstraniteCageBlock.box((double)4.0, (double)20.0, (double)-3.0, (double)12.0, (double)30.0, (double)-1.0));
            case Direction.EAST -> Shapes.or((VoxelShape)AstraniteCageBlock.box((double)-1.0, (double)0.0, (double)-1.0, (double)17.0, (double)32.0, (double)17.0), (VoxelShape)AstraniteCageBlock.box((double)17.0, (double)20.0, (double)4.0, (double)19.0, (double)30.0, (double)12.0));
            case Direction.WEST -> Shapes.or((VoxelShape)AstraniteCageBlock.box((double)-1.0, (double)0.0, (double)-1.0, (double)17.0, (double)32.0, (double)17.0), (VoxelShape)AstraniteCageBlock.box((double)-3.0, (double)20.0, (double)4.0, (double)-1.0, (double)30.0, (double)12.0));
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        AstraniteCageBlockDestroyedByPlayerProcedure.execute((Entity)entity);
        return retval;
    }
}

