/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.block;

import net.mcreator.astraldimension.init.AstralDimensionModBlocks;
import net.mcreator.astraldimension.procedures.SolarShrubBoneMealSuccessConditionProcedure;
import net.mcreator.astraldimension.procedures.SolarShrubOnBoneMealSuccessProcedure;
import net.mcreator.astraldimension.procedures.SolarShrubPlantDestroyedByPlayerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class SolarShrubBlock
extends FlowerBlock
implements BonemealableBlock {
    public SolarShrubBlock() {
        super(MobEffects.MOVEMENT_SPEED, 100.0f, BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).sound(SoundType.BIG_DRIPLEAF).instabreak().hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).noCollission().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public boolean mayPlaceOn(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        return groundState.is((Block)AstralDimensionModBlocks.LUNAR_SOIL.get()) || groundState.is((Block)AstralDimensionModBlocks.SOLAR_MOONSTONE_BRICKS.get());
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)worldIn, blockpos);
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        SolarShrubPlantDestroyedByPlayerProcedure.execute((Entity)entity);
        return retval;
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState blockstate) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState blockstate) {
        return SolarShrubBoneMealSuccessConditionProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState blockstate) {
        SolarShrubOnBoneMealSuccessProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

