/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.klikli_dev.occultism.common.entity.familiar.GoatFamiliarEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class GoatFamiliarModel
extends EntityModel<GoatFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart leftBackLeg1;
    public ModelPart rightBackLeg1;
    public ModelPart neck;
    public ModelPart tail;
    public ModelPart leftFrontLeg1;
    public ModelPart rightFrontLeg1;
    public ModelPart leftBackLeg2;
    public ModelPart leftBackLeg3;
    public ModelPart rightBackLeg2;
    public ModelPart rightBackLeg3;
    public ModelPart head;
    public ModelPart bell1;
    public ModelPart rightHorn1;
    public ModelPart mouth;
    public ModelPart leftHorn1;
    public ModelPart leftEyeEvil;
    public ModelPart rightEyeEvil;
    public ModelPart leftSideHornEvil1;
    public ModelPart rightSideHornEvil1;
    public ModelPart rightHorn2;
    public ModelPart beard;
    public ModelPart ring;
    public ModelPart leftHorn2;
    public ModelPart leftPupilEvil;
    public ModelPart rightPupilEvil;
    public ModelPart leftSideHornEvil2;
    public ModelPart leftSideHornEvil3;
    public ModelPart rightSideHornEvil2;
    public ModelPart rightSideHornEvil3;
    public ModelPart bell2;
    public ModelPart bell3;
    public ModelPart leftFrontLeg2;
    public ModelPart leftFrontLeg3;
    public ModelPart rightFrontLeg2;
    public ModelPart rightFrontLeg3;

    public GoatFamiliarModel(ModelPart part) {
        this.body = part.getChild("body");
        this.leftBackLeg1 = this.body.getChild("leftBackLeg1");
        this.rightBackLeg1 = this.body.getChild("rightBackLeg1");
        this.neck = this.body.getChild("neck");
        this.tail = this.body.getChild("tail");
        this.leftFrontLeg1 = this.body.getChild("leftFrontLeg1");
        this.rightFrontLeg1 = this.body.getChild("rightFrontLeg1");
        this.leftBackLeg2 = this.leftBackLeg1.getChild("leftBackLeg2");
        this.leftBackLeg3 = this.leftBackLeg2.getChild("leftBackLeg3");
        this.rightBackLeg2 = this.rightBackLeg1.getChild("rightBackLeg2");
        this.rightBackLeg3 = this.rightBackLeg2.getChild("rightBackLeg3");
        this.head = this.neck.getChild("head");
        this.bell1 = this.neck.getChild("bell1");
        this.rightHorn1 = this.head.getChild("rightHorn1");
        this.mouth = this.head.getChild("mouth");
        this.leftHorn1 = this.head.getChild("leftHorn1");
        this.leftEyeEvil = this.head.getChild("leftEyeEvil");
        this.rightEyeEvil = this.head.getChild("rightEyeEvil");
        this.leftSideHornEvil1 = this.head.getChild("leftSideHornEvil1");
        this.rightSideHornEvil1 = this.head.getChild("rightSideHornEvil1");
        this.rightHorn2 = this.rightHorn1.getChild("rightHorn2");
        this.beard = this.mouth.getChild("beard");
        this.ring = this.mouth.getChild("ring");
        this.leftHorn2 = this.leftHorn1.getChild("leftHorn2");
        this.leftPupilEvil = this.leftEyeEvil.getChild("leftPupilEvil");
        this.rightPupilEvil = this.rightEyeEvil.getChild("rightPupilEvil");
        this.leftSideHornEvil2 = this.leftSideHornEvil1.getChild("leftSideHornEvil2");
        this.leftSideHornEvil3 = this.leftSideHornEvil2.getChild("leftSideHornEvil3");
        this.rightSideHornEvil2 = this.rightSideHornEvil1.getChild("rightSideHornEvil2");
        this.rightSideHornEvil3 = this.rightSideHornEvil2.getChild("rightSideHornEvil3");
        this.bell2 = this.bell1.getChild("bell2");
        this.bell3 = this.bell2.getChild("bell3");
        this.leftFrontLeg2 = this.leftFrontLeg1.getChild("leftFrontLeg2");
        this.leftFrontLeg3 = this.leftFrontLeg2.getChild("leftFrontLeg3");
        this.rightFrontLeg2 = this.rightFrontLeg1.getChild("rightFrontLeg2");
        this.rightFrontLeg3 = this.rightFrontLeg2.getChild("rightFrontLeg3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition body = parts.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -5.0f, 4.0f, 5.0f, 10.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)17.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftBackLeg1 = body.addOrReplaceChild("leftBackLeg1", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.8f, (float)-0.1f, (float)3.9f, (float)-0.23457225f, (float)0.0f, (float)0.0f));
        PartDefinition rightBackLeg1 = body.addOrReplaceChild("rightBackLeg1", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, true), PartPose.offsetAndRotation((float)-1.8f, (float)-0.1f, (float)3.9f, (float)-0.23457225f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(36, 0).addBox(-1.0f, -1.5f, -4.0f, 2.0f, 3.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.8f, (float)-3.6f, (float)-0.87266463f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(55, 6).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.6f, (float)4.3f, (float)0.19547687f, (float)0.0f, (float)0.0f));
        PartDefinition leftFrontLeg1 = body.addOrReplaceChild("leftFrontLeg1", CubeListBuilder.create().texOffs(37, 7).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 5.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.8f, (float)-0.1f, (float)-3.1f, (float)-0.12217305f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg1 = body.addOrReplaceChild("rightFrontLeg1", CubeListBuilder.create().texOffs(37, 7).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 5.0f, 2.0f, true), PartPose.offsetAndRotation((float)-1.8f, (float)-0.1f, (float)-3.1f, (float)-0.12217305f, (float)0.0f, (float)0.0f));
        PartDefinition leftBackLeg2 = leftBackLeg1.addOrReplaceChild("leftBackLeg2", CubeListBuilder.create().texOffs(18, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)-0.01f, (float)3.3f, (float)-0.1f, (float)0.86009824f, (float)0.0f, (float)0.0f));
        PartDefinition leftBackLeg3 = leftBackLeg2.addOrReplaceChild("leftBackLeg3", CubeListBuilder.create().texOffs(6, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.01f, (float)2.2f, (float)0.5f, (float)-1.2119566f, (float)0.0f, (float)0.0f));
        PartDefinition rightBackLeg2 = rightBackLeg1.addOrReplaceChild("rightBackLeg2", CubeListBuilder.create().texOffs(18, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)-0.01f, (float)3.3f, (float)-0.1f, (float)0.86009824f, (float)0.0f, (float)0.0f));
        PartDefinition rightBackLeg3 = rightBackLeg2.addOrReplaceChild("rightBackLeg3", CubeListBuilder.create().texOffs(6, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, true), PartPose.offsetAndRotation((float)0.01f, (float)2.2f, (float)0.5f, (float)-1.2119566f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(48, 0).addBox(-1.5f, -1.5f, -3.0f, 3.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-0.8f, (float)-3.1f, (float)0.9641199f, (float)0.0f, (float)0.0f));
        PartDefinition bell1 = neck.addOrReplaceChild("bell1", CubeListBuilder.create().texOffs(0, 15).addBox(-1.5f, 0.0f, -0.5f, 3.0f, 4.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.01f, (float)-1.6f, (float)-2.1f, (float)0.1563815f, (float)0.0f, (float)0.0f));
        PartDefinition rightHorn1 = head.addOrReplaceChild("rightHorn1", CubeListBuilder.create().texOffs(18, 4).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)-0.9f, (float)-0.6f, (float)0.2f, (float)-0.17453292f, (float)0.0f, (float)0.0f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(27, 4).addBox(-1.0f, -1.5f, -3.0f, 2.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.5f, (float)0.19198622f, (float)0.0f, (float)0.0f));
        PartDefinition leftHorn1 = head.addOrReplaceChild("leftHorn1", CubeListBuilder.create().texOffs(18, 4).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.9f, (float)-0.6f, (float)0.2f, (float)-0.17453292f, (float)0.0f, (float)0.0f));
        PartDefinition leftEyeEvil = head.addOrReplaceChild("leftEyeEvil", CubeListBuilder.create().texOffs(24, 15).addBox(-0.5f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.3f, (float)-0.2f, (float)-1.7f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightEyeEvil = head.addOrReplaceChild("rightEyeEvil", CubeListBuilder.create().texOffs(24, 15).addBox(-0.5f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)-1.3f, (float)-0.2f, (float)-1.7f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftSideHornEvil1 = head.addOrReplaceChild("leftSideHornEvil1", CubeListBuilder.create().texOffs(27, 0).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.0f, (float)0.4f, (float)-0.3f, (float)0.6981317f, (float)0.0f, (float)0.89919364f));
        PartDefinition rightSideHornEvil1 = head.addOrReplaceChild("rightSideHornEvil1", CubeListBuilder.create().texOffs(27, 0).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)-1.0f, (float)0.4f, (float)-0.3f, (float)0.6981317f, (float)0.0f, (float)-0.89919364f));
        PartDefinition rightHorn2 = rightHorn1.addOrReplaceChild("rightHorn2", CubeListBuilder.create().texOffs(57, 0).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, true), PartPose.offsetAndRotation((float)0.01f, (float)0.2f, (float)1.0f, (float)-0.17453292f, (float)0.0f, (float)0.0f));
        PartDefinition beard = mouth.addOrReplaceChild("beard", CubeListBuilder.create().texOffs(45, 6).addBox(-1.0f, -1.5f, -3.0f, 2.0f, 2.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition ring = mouth.addOrReplaceChild("ring", CubeListBuilder.create().texOffs(0, 29).addBox(-2.0f, 0.0f, -3.0f, 4.0f, 0.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-2.0f, (float)0.57595867f, (float)0.0f, (float)0.0f));
        PartDefinition leftHorn2 = leftHorn1.addOrReplaceChild("leftHorn2", CubeListBuilder.create().texOffs(57, 0).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, false), PartPose.offsetAndRotation((float)-0.01f, (float)0.2f, (float)1.0f, (float)-0.17453292f, (float)0.0f, (float)0.0f));
        PartDefinition leftPupilEvil = leftEyeEvil.addOrReplaceChild("leftPupilEvil", CubeListBuilder.create().texOffs(22, 15).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.2f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition rightPupilEvil = rightEyeEvil.addOrReplaceChild("rightPupilEvil", CubeListBuilder.create().texOffs(22, 15).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, true), PartPose.offsetAndRotation((float)-0.2f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition leftSideHornEvil2 = leftSideHornEvil1.addOrReplaceChild("leftSideHornEvil2", CubeListBuilder.create().texOffs(33, 0).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, false), PartPose.offsetAndRotation((float)-0.01f, (float)-0.2f, (float)0.9f, (float)-0.44820055f, (float)0.0f, (float)0.0f));
        PartDefinition leftSideHornEvil3 = leftSideHornEvil2.addOrReplaceChild("leftSideHornEvil3", CubeListBuilder.create().texOffs(33, 0).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, false), PartPose.offsetAndRotation((float)-0.01f, (float)0.0f, (float)1.0f, (float)0.4509931f, (float)0.0f, (float)0.0f));
        PartDefinition rightSideHornEvil2 = rightSideHornEvil1.addOrReplaceChild("rightSideHornEvil2", CubeListBuilder.create().texOffs(33, 0).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, true), PartPose.offsetAndRotation((float)-0.01f, (float)-0.2f, (float)0.9f, (float)-0.44820055f, (float)0.0f, (float)0.0f));
        PartDefinition rightSideHornEvil3 = rightSideHornEvil2.addOrReplaceChild("rightSideHornEvil3", CubeListBuilder.create().texOffs(33, 0).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, true), PartPose.offsetAndRotation((float)-0.01f, (float)0.0f, (float)1.0f, (float)0.4509931f, (float)0.0f, (float)0.0f));
        PartDefinition bell2 = bell1.addOrReplaceChild("bell2", CubeListBuilder.create().texOffs(0, 21).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-0.1f, (float)0.6646214f, (float)0.0f, (float)0.0f));
        PartDefinition bell3 = bell2.addOrReplaceChild("bell3", CubeListBuilder.create().texOffs(0, 25).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 1.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftFrontLeg2 = leftFrontLeg1.addOrReplaceChild("leftFrontLeg2", CubeListBuilder.create().texOffs(0, 6).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.offsetAndRotation((float)-0.01f, (float)4.6f, (float)0.0f, (float)0.312763f, (float)0.0f, (float)0.0f));
        PartDefinition leftFrontLeg3 = leftFrontLeg2.addOrReplaceChild("leftFrontLeg3", CubeListBuilder.create().texOffs(22, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.01f, (float)1.5f, (float)0.0f, (float)-0.19495328f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg2 = rightFrontLeg1.addOrReplaceChild("rightFrontLeg2", CubeListBuilder.create().texOffs(0, 6).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, true), PartPose.offsetAndRotation((float)-0.01f, (float)4.6f, (float)0.0f, (float)0.312763f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg3 = rightFrontLeg2.addOrReplaceChild("rightFrontLeg3", CubeListBuilder.create().texOffs(22, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, true), PartPose.offsetAndRotation((float)-0.01f, (float)1.5f, (float)-0.1f, (float)-0.19495328f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        this.body.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
    }

    public void setupAnim(GoatFamiliarEntity pEntity, float limbSwing, float limbSwingAmount, float pAgeInTicks, float netHeadYaw, float headPitch) {
        this.showModels(pEntity);
        this.body.zRot = 0.0f;
        this.neck.xRot = -0.87f;
        this.head.yRot = this.toRads(netHeadYaw) * 0.5f;
        this.head.zRot = this.toRads(netHeadYaw) * 0.5f;
        this.head.xRot = this.toRads(headPitch) * 0.5f + 0.96f;
        this.rightBackLeg1.xRot = Mth.cos((float)(limbSwing * 0.7f)) * 0.8f * limbSwingAmount - 0.23f;
        this.leftBackLeg1.xRot = Mth.cos((float)(limbSwing * 0.7f + (float)Math.PI)) * 0.8f * limbSwingAmount - 0.23f;
        this.rightFrontLeg1.xRot = Mth.cos((float)(limbSwing * 0.7f + (float)Math.PI)) * 0.8f * limbSwingAmount - 0.12f;
        this.leftFrontLeg1.xRot = Mth.cos((float)(limbSwing * 0.7f)) * 0.8f * limbSwingAmount - 0.12f;
        if (pEntity.isSitting()) {
            this.body.zRot = this.toRads(90.0f);
            this.neck.xRot = this.toRads(10.0f);
        }
        if (pEntity.isPartying()) {
            this.body.zRot = this.toRads(180.0f);
            this.neck.xRot = this.toRads(10.0f);
            this.rightBackLeg1.xRot = Mth.cos((float)(pAgeInTicks * 0.5f)) * this.toRads(25.0f) - 0.23f;
            this.leftBackLeg1.xRot = Mth.cos((float)(pAgeInTicks * 0.5f + (float)Math.PI)) * this.toRads(25.0f) - 0.23f;
            this.rightFrontLeg1.xRot = Mth.cos((float)(pAgeInTicks * 0.5f + (float)Math.PI)) * this.toRads(25.0f) - 0.12f;
            this.leftFrontLeg1.xRot = Mth.cos((float)(pAgeInTicks * 0.5f)) * this.toRads(25.0f) - 0.12f;
        }
        this.bell2.zRot = Mth.cos((float)(limbSwing * 0.7f)) * 0.5f * limbSwingAmount;
    }

    public void prepareMobModel(GoatFamiliarEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.neck.yRot = pEntity.getNeckYRot(pPartialTick);
    }

    private void showModels(GoatFamiliarEntity entityIn) {
        boolean hasRedEyes = entityIn.hasRedEyes();
        boolean hasEvilHorns = entityIn.hasEvilHorns();
        this.ring.visible = entityIn.hasRing();
        this.beard.visible = entityIn.hasBeard();
        this.bell1.visible = entityIn.hasBlacksmithUpgrade();
        this.leftEyeEvil.visible = hasRedEyes;
        this.rightEyeEvil.visible = hasRedEyes;
        this.leftHorn1.visible = !hasEvilHorns;
        this.rightHorn1.visible = !hasEvilHorns;
        this.leftSideHornEvil1.visible = hasEvilHorns;
        this.rightSideHornEvil1.visible = hasEvilHorns;
    }

    private float toRads(float deg) {
        return (float)Math.toRadians(deg);
    }
}

