/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block.otherworld;

import com.klikli_dev.occultism.api.common.data.OtherworldBlockTier;
import com.klikli_dev.occultism.common.block.otherworld.IOtherworldBlock;
import com.klikli_dev.occultism.datagen.worldgen.ConfiguredFeatures;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class OtherworldSaplingNaturalBlock
extends SaplingBlock
implements IOtherworldBlock {
    public static final TreeGrower TREE_GROWER = new TreeGrower("otherworld_natural", Optional.empty(), Optional.of(ConfiguredFeatures.TREE_OTHERWORLD_NATURAL), Optional.empty());

    public OtherworldSaplingNaturalBlock(BlockBehaviour.Properties properties) {
        super(TREE_GROWER, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(UNCOVERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Block getUncoveredBlock() {
        return this;
    }

    @Override
    public Block getCoveredBlock() {
        return Blocks.OAK_SAPLING;
    }

    @Override
    public OtherworldBlockTier getTier() {
        return OtherworldBlockTier.ONE;
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(worldIn, player, pos, IOtherworldBlock.super.getHarvestState(player, state, stack), te, stack);
    }

    public String getDescriptionId() {
        return "block.minecraft.oak_sapling";
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return IOtherworldBlock.super.getItem((BlockGetter)pLevel, pPos, pState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UNCOVERED});
        super.createBlockStateDefinition(builder);
    }
}

