/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.blockentity;

import com.klikli_dev.occultism.api.common.blockentity.IStorageAccessor;
import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.blockentity.IStorageControllerProxy;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.api.common.data.SortDirection;
import com.klikli_dev.occultism.api.common.data.SortType;
import com.klikli_dev.occultism.common.block.storage.StableWormholeBlock;
import com.klikli_dev.occultism.common.blockentity.NetworkedBlockEntity;
import com.klikli_dev.occultism.common.blockentity.StorageControllerBlockEntity;
import com.klikli_dev.occultism.common.container.storage.StableWormholeContainer;
import com.klikli_dev.occultism.registry.OccultismBlockEntities;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.util.BlockEntityUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class StableWormholeBlockEntity
extends NetworkedBlockEntity
implements IStorageControllerProxy,
MenuProvider,
IStorageAccessor {
    protected GlobalBlockPos linkedStorageControllerPosition;
    protected Map<Integer, ItemStack> matrix = new HashMap<Integer, ItemStack>();
    protected ItemStack orderStack = ItemStack.EMPTY;
    protected SortDirection sortDirection = SortDirection.DOWN;
    protected SortType sortType = SortType.AMOUNT;

    public StableWormholeBlockEntity(BlockPos worldPos, BlockState state) {
        super(OccultismBlockEntities.STABLE_WORMHOLE.get(), worldPos, state);
    }

    @Override
    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    @Override
    public void setSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
    }

    @Override
    public SortType getSortType() {
        return this.sortType;
    }

    @Override
    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    @Override
    public Map<Integer, ItemStack> getMatrix() {
        return this.matrix;
    }

    @Override
    public ItemStack getOrderStack() {
        return this.orderStack;
    }

    @Override
    public void setOrderStack(@Nonnull ItemStack orderStack) {
        this.orderStack = orderStack;
    }

    public Component getDisplayName() {
        return Component.literal((String)BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)this.getType()).getPath());
    }

    public boolean controllerLoaded() {
        return BlockEntityUtil.isLoaded(this.level, this.linkedStorageControllerPosition);
    }

    @Override
    public IStorageController getLinkedStorageController() {
        if (this.linkedStorageControllerPosition != null) {
            if (!this.controllerLoaded()) {
                return null;
            }
            BlockEntity blockEntity = BlockEntityUtil.get(this.level, this.linkedStorageControllerPosition);
            if (blockEntity instanceof IStorageController) {
                IStorageController controller = (IStorageController)blockEntity;
                return controller;
            }
            if (!this.level.isClientSide) {
                this.linkedStorageControllerPosition = null;
                this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(StableWormholeBlock.LINKED, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
        return null;
    }

    @Override
    public GlobalBlockPos getLinkedStorageControllerPosition() {
        return this.linkedStorageControllerPosition;
    }

    @Override
    public void setLinkedStorageControllerPosition(GlobalBlockPos blockPos) {
        this.linkedStorageControllerPosition = blockPos;
    }

    @Override
    public void loadNetwork(CompoundTag compound, HolderLookup.Provider provider) {
        if (compound.contains("linkedStorageControllerPosition")) {
            this.linkedStorageControllerPosition = GlobalBlockPos.from(provider, compound.getCompound("linkedStorageControllerPosition"));
        }
        this.setSortDirection(SortDirection.BY_ID.apply(compound.getInt("sortDirection")));
        this.setSortType(SortType.BY_ID.apply(compound.getInt("sortType")));
        if (compound.contains("matrix")) {
            this.matrix = StorageControllerBlockEntity.loadMatrix(compound.getCompound("matrix"), provider);
        }
        if (compound.contains("orderStack")) {
            this.orderStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound.getCompound("orderStack"));
        }
        super.loadNetwork(compound, provider);
    }

    @Override
    public CompoundTag saveNetwork(CompoundTag compound, HolderLookup.Provider provider) {
        if (this.linkedStorageControllerPosition != null) {
            compound.put("linkedStorageControllerPosition", (Tag)this.linkedStorageControllerPosition.serializeNBT(provider));
        }
        compound.putInt("sortDirection", this.getSortDirection().ordinal());
        compound.putInt("sortType", this.getSortType().ordinal());
        compound.put("matrix", (Tag)StorageControllerBlockEntity.saveMatrix(this.matrix, provider));
        if (!this.orderStack.isEmpty()) {
            compound.put("orderStack", this.orderStack.saveOptional(provider));
        }
        return super.saveNetwork(compound, provider);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        if (pComponentInput.get(OccultismDataComponents.LINKED_STORAGE_CONTROLLER) != null) {
            this.linkedStorageControllerPosition = (GlobalBlockPos)pComponentInput.get(OccultismDataComponents.LINKED_STORAGE_CONTROLLER);
        }
        if (pComponentInput.get(OccultismDataComponents.SORT_DIRECTION) != null) {
            this.sortDirection = (SortDirection)((Object)pComponentInput.get(OccultismDataComponents.SORT_DIRECTION));
        }
        if (pComponentInput.get(OccultismDataComponents.SORT_TYPE) != null) {
            this.sortType = (SortType)((Object)pComponentInput.get(OccultismDataComponents.SORT_TYPE));
        }
        if (pComponentInput.get(OccultismDataComponents.CRAFTING_MATRIX) != null) {
            this.matrix = StorageControllerBlockEntity.loadMatrix(((CustomData)pComponentInput.get(OccultismDataComponents.CRAFTING_MATRIX)).getUnsafe(), (HolderLookup.Provider)this.level.registryAccess());
        }
        if (pComponentInput.get(OccultismDataComponents.ORDER_STACK) != null) {
            this.orderStack = ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)((CustomData)pComponentInput.get(OccultismDataComponents.ORDER_STACK)).getUnsafe());
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(OccultismDataComponents.LINKED_STORAGE_CONTROLLER, (Object)this.linkedStorageControllerPosition);
        pComponents.set(OccultismDataComponents.SORT_DIRECTION, (Object)this.sortDirection);
        pComponents.set(OccultismDataComponents.SORT_TYPE, (Object)this.sortType);
        pComponents.set(OccultismDataComponents.CRAFTING_MATRIX, (Object)CustomData.of((CompoundTag)StorageControllerBlockEntity.saveMatrix(this.matrix, (HolderLookup.Provider)this.level.registryAccess())));
        pComponents.set(OccultismDataComponents.ORDER_STACK, (Object)CustomData.of((CompoundTag)((CompoundTag)this.orderStack.saveOptional((HolderLookup.Provider)this.level.registryAccess()))));
    }

    public void removeComponentsFromTag(CompoundTag pTag) {
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new StableWormholeContainer(id, playerInventory, this);
    }
}

