/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.misc;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.common.data.NonNullArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class StorageControllerItemStackHandler
extends ItemStackHandler {
    protected int maxStackSize;
    protected int maxSlots;
    protected boolean overrideItemStackSizes;
    protected IStorageController storageController;

    public StorageControllerItemStackHandler(IStorageController storageController, int size, int maxStackSize, boolean overrideItemStackSizes) {
        this.stacks = NonNullArrayList.withSize(size, ItemStack.EMPTY);
        this.storageController = storageController;
        this.maxSlots = size;
        this.maxStackSize = maxStackSize;
        this.overrideItemStackSizes = overrideItemStackSizes;
    }

    public void setSize(int size) {
        if (size < 0) {
            return;
        }
        this.maxSlots = size;
        if (size > this.stacks.size()) {
            this.stacks.addAll(Collections.nCopies(size - this.stacks.size(), ItemStack.EMPTY));
        } else if (size < this.stacks.size()) {
            this.prune();
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot > this.maxSlots - 1) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack result = this.extractItemOverride(slot, amount, simulate);
        if (!simulate && this.stacks.size() > this.maxSlots && ((ItemStack)this.stacks.get(slot)).isEmpty()) {
            this.stacks.remove(slot);
        }
        return result;
    }

    public ItemStack extractItemOverride(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, this.getStackLimit(-1, existing));
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.EMPTY);
                this.onContentsChanged(slot);
                return existing;
            }
            return existing.copy();
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)existing.copyWithCount(existing.getCount() - toExtract));
            this.onContentsChanged(slot);
        }
        return existing.copyWithCount(toExtract);
    }

    public int getSlotLimit(int slot) {
        return this.maxStackSize;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return this.overrideItemStackSizes ? this.getSlotLimit(slot) : Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            ItemStack stack = (ItemStack)this.stacks.get(i);
            itemTag.putInt("Slot", i);
            stack.save(provider, (Tag)itemTag);
            itemTag.putInt("RealSize", stack.getCount());
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)nbtTagList);
        nbt.putInt("Size", this.stacks.size());
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.setSize(nbt.contains("Size", 3) ? nbt.getInt("Size") : this.stacks.size());
        ListTag tagList = nbt.getList("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.getCompound(i);
            int slot = itemTags.getInt("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemTags);
            stack.setCount(itemTags.getInt("RealSize"));
            this.stacks.set(slot, (Object)stack);
        }
        this.onLoad();
    }

    protected void onContentsChanged(int slot) {
        if (this.storageController != null) {
            this.storageController.onContentsChanged();
        }
    }

    public void prune() {
        for (int i = this.stacks.size() - 1; i >= 0 && this.stacks.size() > this.maxSlots; --i) {
            if (!((ItemStack)this.stacks.get(i)).isEmpty()) continue;
            this.stacks.remove(i);
        }
    }
}

