/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.klikli_dev.occultism.api.common.data.SortDirection;
import com.klikli_dev.occultism.api.common.data.SortType;
import com.klikli_dev.occultism.common.container.storage.StableWormholeContainer;
import com.klikli_dev.occultism.common.container.storage.StorageControllerContainer;
import com.klikli_dev.occultism.common.container.storage.StorageRemoteContainer;
import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class MessageUpdateStorageSettings
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"update_storage_settings");
    public static final CustomPacketPayload.Type<MessageUpdateStorageSettings> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageUpdateStorageSettings> STREAM_CODEC = CustomPacketPayload.codec(MessageUpdateStorageSettings::encode, MessageUpdateStorageSettings::new);
    private SortDirection sortDirection;
    private SortType sortType;

    public MessageUpdateStorageSettings(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageUpdateStorageSettings(SortDirection sortDirection, SortType sortType) {
        this.sortDirection = sortDirection;
        this.sortType = sortType;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof IStorageControllerContainer) {
            StorageRemoteContainer storageRemoteContainer;
            ItemStack remote;
            IStorageControllerContainer storageContainer = (IStorageControllerContainer)abstractContainerMenu;
            IStorageController storageController = storageContainer.getStorageController();
            if (storageContainer instanceof StorageRemoteContainer && (remote = (storageRemoteContainer = (StorageRemoteContainer)storageContainer).getStorageRemote()) != ItemStack.EMPTY) {
                remote.set(OccultismDataComponents.SORT_DIRECTION, (Object)this.sortDirection);
                remote.set(OccultismDataComponents.SORT_TYPE, (Object)this.sortType);
                player.containerMenu.broadcastChanges();
            }
            if (storageContainer instanceof StorageControllerContainer) {
                StorageControllerContainer storageControllerContainer = (StorageControllerContainer)storageContainer;
                storageControllerContainer.getStorageController().setSortDirection(this.sortDirection);
                storageControllerContainer.getStorageController().setSortType(this.sortType);
                storageControllerContainer.getStorageController().markNetworkDirty();
            }
            if (storageContainer instanceof StableWormholeContainer) {
                StableWormholeContainer stableWormholeContainer = (StableWormholeContainer)storageContainer;
                stableWormholeContainer.getStableWormhole().setSortDirection(this.sortDirection);
                stableWormholeContainer.getStableWormhole().setSortType(this.sortType);
                stableWormholeContainer.getStableWormhole().markNetworkDirty();
            }
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.sortDirection);
        buf.writeEnum((Enum)this.sortType);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.sortDirection = (SortDirection)buf.readEnum(SortDirection.class);
        this.sortType = (SortType)buf.readEnum(SortType.class);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

