/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.common.items.bangles;

import alexthw.ars_elemental.common.items.ElementalCurio;
import com.alexthw.sauce.api.item.ISchoolBangle;
import com.alexthw.sauce.registry.ModRegistry;
import com.google.common.collect.Multimap;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.NeoForgeMod;
import top.theillusivec4.curios.api.SlotContext;

public class ElemancyBangle
extends ElementalCurio
implements ISchoolBangle {
    public final SpellSchool school;

    public ElemancyBangle(Item.Properties pProperties, SpellSchool school) {
        super(pProperties);
        this.school = school;
    }

    public SpellSchool getSchool() {
        return this.school;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation uuid, ItemStack stack) {
        Multimap map = super.getAttributeModifiers(slotContext, uuid, stack);
        ArrayList subschools = new ArrayList(this.school.getSubSchools());
        block16: for (SpellSchool sub : subschools) {
            switch (sub.getId()) {
                case "air": {
                    map.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(uuid, (double)0.06f, AttributeModifier.Operation.ADD_VALUE));
                    map.put((Object)Attributes.ATTACK_KNOCKBACK, (Object)new AttributeModifier(uuid, (double)1.2f, AttributeModifier.Operation.ADD_VALUE));
                    break;
                }
                case "anima": {
                    map.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(uuid, 4.0, AttributeModifier.Operation.ADD_VALUE));
                    break;
                }
                case "earth": {
                    map.put((Object)Attributes.KNOCKBACK_RESISTANCE, (Object)new AttributeModifier(uuid, 0.3, AttributeModifier.Operation.ADD_VALUE));
                    break;
                }
                case "fire": {
                    Holder biome;
                    LivingEntity entity = slotContext.entity();
                    if (entity == null || !(((Biome)(biome = entity.level().getBiome(slotContext.entity().getOnPos())).value()).getBaseTemperature() > 1.8f)) continue block16;
                    map.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(uuid, (double)0.035f, AttributeModifier.Operation.ADD_VALUE));
                    break;
                }
                case "summon": {
                    map.put((Object)ModRegistry.SUMMON_POWER, (Object)new AttributeModifier(uuid, 2.0, AttributeModifier.Operation.ADD_VALUE));
                    break;
                }
                case "water": {
                    map.put((Object)NeoForgeMod.SWIM_SPEED, (Object)new AttributeModifier(uuid, 0.5, AttributeModifier.Operation.ADD_VALUE));
                    if (slotContext.entity() == null || !slotContext.entity().isInWaterOrRain()) break;
                    map.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(uuid, (double)0.035f, AttributeModifier.Operation.ADD_VALUE));
                }
            }
        }
        return map;
    }
}

