/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.builtinpacks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cristelknight.cristellib.builtinpacks.BuiltInDataPackLoader;
import de.cristelknight.cristellib.config.simple.ConfigRegistry;
import de.cristelknight.cristellib.config.simple.ConfigSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.Util;

public record BuiltInPackConfig(List<String> defaultPacks, List<String> disabledPacks, boolean hideAllPacksInScreen) {
    public static final Codec<BuiltInPackConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.list((Codec)Codec.STRING).fieldOf("defaultPacks").forGetter(BuiltInPackConfig::defaultPacks), (App)Codec.list((Codec)Codec.STRING).fieldOf("disabledPacks").forGetter(BuiltInPackConfig::disabledPacks), (App)Codec.BOOL.fieldOf("hideAllPacksInScreen").forGetter(BuiltInPackConfig::hideAllPacksInScreen)).apply((Applicative)builder, BuiltInPackConfig::new));
    public static final ConfigSettings<BuiltInPackConfig> SETTINGS = new ConfigSettings<BuiltInPackConfig>(){

        @Override
        public String getSubPath() {
            return "cristellib/built_in_packs";
        }

        @Override
        public Codec<BuiltInPackConfig> getCodec() {
            return CODEC;
        }

        @Override
        public BuiltInPackConfig getDefault() {
            return new BuiltInPackConfig(BuiltInDataPackLoader.getCustomIDs(), List.of(), false);
        }

        @Override
        public String getHeader() {
            return "This config allows disabling built-in packs supplied by Cristel Lib.\nMove entries from 'defaultPacks' to 'disabledPacks' to disable them.\n";
        }

        @Override
        public HashMap<String, String> getComments() {
            return (HashMap)Util.make(new HashMap(), map -> map.put("hideAllPacksInScreen", "This option hides all packs provided by Cristel Lib in the pack selection screen to reduce clutter."));
        }
    };

    public static void updateConfig() {
        BuiltInPackConfig config = ConfigRegistry.get(BuiltInPackConfig.class);
        ArrayList<String> defaultPacks = new ArrayList<String>(config.defaultPacks());
        ArrayList<String> disabledPacks = new ArrayList<String>(config.disabledPacks());
        boolean bl = false;
        if (defaultPacks.retainAll(SETTINGS.getDefault().defaultPacks())) {
            bl = true;
        }
        if (disabledPacks.retainAll(SETTINGS.getDefault().defaultPacks())) {
            bl = true;
        }
        for (String item : SETTINGS.getDefault().defaultPacks()) {
            if (defaultPacks.contains(item) || disabledPacks.contains(item)) continue;
            defaultPacks.add(item);
            bl = true;
        }
        if (bl) {
            ConfigRegistry.updateAndSave(new BuiltInPackConfig(defaultPacks, disabledPacks, config.hideAllPacksInScreen()));
        }
    }

    static {
        ConfigRegistry.registerWithScreen(BuiltInPackConfig.class, SETTINGS, "cristellib", "Built-in Packs", BuiltInPackConfig::updateConfig);
    }
}

