/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.config.client.simple;

import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.config.client.simple.ClientConfigRegistry;
import de.cristelknight.cristellib.config.client.simple.SimpleConfigScreen;
import de.cristelknight.cristellib.config.simple.ConfigHolder;
import de.cristelknight.cristellib.config.simple.ConfigRegistry;
import de.cristelknight.cristellib.config.simple.ConfigSettings;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SimpleScreenBuilder {
    private static final Map<Class<?>, Map<String, Object>> pendingUpdates = new HashMap();

    public static void saveConfigs(String modID) {
        Map<String, Set<SimpleConfigScreen>> simpleConfigsWithScreen = ClientConfigRegistry.getAllConfigsWithScreen();
        if (!simpleConfigsWithScreen.containsKey(modID)) {
            return;
        }
        for (SimpleConfigScreen simpleConfig : simpleConfigsWithScreen.get(modID)) {
            SimpleScreenBuilder.saveConfig(simpleConfig.simpleConfig(), modID);
        }
    }

    public static <T> void saveConfig(Class<T> config, String modID) {
        T configInstance = ConfigRegistry.get(config);
        try {
            T updated = SimpleScreenBuilder.rebuildConfigInstance(config, configInstance);
            ConfigHolder<T> holder = ConfigRegistry.holder(config);
            holder.update(updated);
            Objects.requireNonNull(ClientConfigRegistry.getScreen(modID, config)).onScreenSave().run();
            holder.save();
        }
        catch (Exception e) {
            CristelLib.LOGGER.error("Couldn't save config screen: {}; ErrorMsg: {}", (Object)config.getSimpleName(), (Object)e.getMessage());
        }
    }

    public static <T> void addConfigToCategory(ConfigBuilder builder, ConfigEntryBuilder entryBuilder, SimpleConfigScreen simpleScreen) {
        Class<?> config = simpleScreen.simpleConfig();
        Object configInstance = ConfigRegistry.get(config);
        ConfigSettings<?> settings = ConfigRegistry.getSettings(config);
        HashMap<String, String> comments = ConfigHolder.getSafeComments(settings.getComments());
        String categoryName = simpleScreen.screenName();
        ConfigCategory category = builder.getOrCreateCategory((Component)Component.literal((String)(categoryName.isEmpty() ? config.getSimpleName() : categoryName)));
        String header = settings.getHeader();
        if (header != null && !header.isEmpty()) {
            category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.literal((String)header.trim())).build());
        }
        for (RecordComponent component : config.getRecordComponents()) {
            List list;
            Object defaultValue;
            Object value;
            String name = component.getName();
            Class<?> type = component.getType();
            try {
                value = component.getAccessor().invoke(configInstance, new Object[0]);
                defaultValue = component.getAccessor().invoke(settings.getDefault(), new Object[0]);
            }
            catch (Exception e) {
                CristelLib.LOGGER.error("Couldn't read config value for config: {}; ErrorMsg: {}", (Object)config.getSimpleName(), (Object)e.getMessage());
                continue;
            }
            if (type == String.class) {
                category.addEntry((AbstractConfigListEntry)entryBuilder.startStrField((Component)Component.literal((String)name), (String)value).setDefaultValue((String)defaultValue).setTooltipSupplier(() -> SimpleScreenBuilder.tooltip(name, comments)).setSaveConsumer(val -> SimpleScreenBuilder.updateFieldValue(config, name, val)).build());
                continue;
            }
            if (type == Integer.TYPE || type == Integer.class) {
                category.addEntry((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.literal((String)name), ((Integer)value).intValue()).setDefaultValue((Object)((Integer)defaultValue))).setTooltipSupplier(() -> SimpleScreenBuilder.tooltip(name, comments)).setSaveConsumer(val -> SimpleScreenBuilder.updateFieldValue(config, name, val)).build());
                continue;
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                category.addEntry((AbstractConfigListEntry)((BooleanToggleBuilder)entryBuilder.startBooleanToggle((Component)Component.literal((String)name), ((Boolean)value).booleanValue()).setDefaultValue((Object)((Boolean)defaultValue))).setTooltipSupplier(() -> SimpleScreenBuilder.tooltip(name, comments)).setSaveConsumer(val -> SimpleScreenBuilder.updateFieldValue(config, name, val)).build());
                continue;
            }
            if (type == List.class && value instanceof List && (list = (List)value).stream().allMatch(it -> it instanceof String)) {
                category.addEntry((AbstractConfigListEntry)entryBuilder.startStrList((Component)Component.literal((String)name), new ArrayList((List)value)).setDefaultValue((List)defaultValue).setTooltipSupplier(() -> SimpleScreenBuilder.tooltip(name, comments)).setSaveConsumer(val -> SimpleScreenBuilder.updateFieldValue(config, name, val)).build());
                continue;
            }
            category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.literal((String)("Unsupported type: " + name))).build());
        }
    }

    public static Optional<Component[]> tooltip(String name, Map<String, String> comments) {
        String comment = comments.get(name);
        if (comment != null && !comment.isEmpty()) {
            return Optional.of(new MutableComponent[]{Component.literal((String)comment)});
        }
        return Optional.empty();
    }

    private static <T> void updateFieldValue(Class<T> clazz, String fieldName, Object value) {
        pendingUpdates.computeIfAbsent(clazz, k -> new HashMap()).put(fieldName, value);
    }

    private static <T> T rebuildConfigInstance(Class<T> clazz, Object oldInstance) throws Exception {
        RecordComponent[] components = clazz.getRecordComponents();
        Object[] args = new Object[components.length];
        Map updates = pendingUpdates.getOrDefault(clazz, Map.of());
        for (int i = 0; i < components.length; ++i) {
            String name = components[i].getName();
            Object oldValue = components[i].getAccessor().invoke(oldInstance, new Object[0]);
            args[i] = updates.getOrDefault(name, oldValue);
        }
        pendingUpdates.remove(clazz);
        return clazz.getDeclaredConstructor((Class[])Arrays.stream(components).map(RecordComponent::getType).toArray(Class[]::new)).newInstance(args);
    }
}

