/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.block;

import com.catastrophe573.dimdungeons.block.TileEntityLocalTeleporter;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class BlockLocalTeleporter
extends BaseEntityBlock {
    public static String REG_NAME = "block_local_teleporter";

    protected MapCodec<? extends BlockLocalTeleporter> codec() {
        throw new AssertionError((Object)"Implement block codec!");
    }

    public BlockLocalTeleporter() {
        super(BlockBehaviour.Properties.of().pushReaction(PushReaction.BLOCK).randomTicks().strength(9999.0f).sound(SoundType.GLASS).noCollission().lightLevel(p -> 15));
    }

    public RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return ItemStack.EMPTY;
    }

    @Deprecated
    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        BlockEntity tile;
        if (worldIn.isClientSide) {
            return;
        }
        if (!(entityIn instanceof ServerPlayer)) {
            return;
        }
        if (!entityIn.isPassenger() && !entityIn.isVehicle() && entityIn.canUsePortal(false) && (tile = worldIn.getBlockEntity(pos)) != null && tile instanceof TileEntityLocalTeleporter) {
            TileEntityLocalTeleporter te = (TileEntityLocalTeleporter)worldIn.getBlockEntity(pos);
            BlockPos destination = te.getDestination();
            float warpX = destination.getX();
            float warpY = destination.getY();
            float warpZ = destination.getZ();
            float newPitch = (float)te.getPitch();
            float newYaw = (float)te.getYaw();
            this.actuallyPerformTeleport((ServerPlayer)entityIn, worldIn.getServer().getLevel(entityIn.getCommandSenderWorld().dimension()), warpX, warpY, warpZ, newYaw, newPitch);
        }
    }

    protected Entity actuallyPerformTeleport(ServerPlayer player, ServerLevel dim, double x, double y, double z, float destYaw, float destPitch) {
        DimensionTransition dt = new DimensionTransition(dim, new Vec3(x, y, z), new Vec3(0.0, 0.0, 0.0), destYaw, destPitch, false, DimensionTransition.DO_NOTHING);
        player.changeDimension(dt);
        return player;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityLocalTeleporter(pos, state);
    }
}

