/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.dimension;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PersonalBuildData
extends SavedData {
    private ConcurrentHashMap<ChunkPos, OwnerData> ownerMap = new ConcurrentHashMap();
    private static String MY_DATA = "build_data";

    @Nonnull
    public static PersonalBuildData get(Level level) {
        if (level.isClientSide) {
            throw new RuntimeException("Don't access this client-side!");
        }
        if (!DungeonUtils.isDimensionPersonalBuild(level)) {
            throw new RuntimeException("PersonalBuildData is not supposed to exist in other dimensions! Calling this was probably unintended.");
        }
        DimensionDataStorage storage = ((ServerLevel)level).getDataStorage();
        return (PersonalBuildData)storage.computeIfAbsent(new SavedData.Factory(PersonalBuildData::create, PersonalBuildData::load), MY_DATA);
    }

    public OwnerData getOwnerAtPos(ChunkPos pos) {
        return this.ownerMap.getOrDefault(pos, null);
    }

    public ChunkPos getPosForOwner(LivingEntity player) {
        ChunkPos cpos;
        Iterator iter = ((ConcurrentHashMap.KeySetView)this.ownerMap.keySet()).iterator();
        if (player == null || !(player instanceof Player) && !DungeonConfig.enableDebugCheats) {
            DimDungeons.logMessageError("DIMENSIONAL DUNGEONS ERROR: registering personal key for a non-player or a null player.");
            return null;
        }
        while (iter.hasNext()) {
            cpos = (ChunkPos)iter.next();
            OwnerData nextOwner = this.ownerMap.get(cpos);
            if (!nextOwner.uuid.equals(player.getUUID())) continue;
            DimDungeons.logMessageInfo("DIMENSIONAL DUNGEONS: Found existing build plot for player " + player.getName().getString() + " at (" + cpos.x + ", " + cpos.z + ")");
            return cpos;
        }
        cpos = this.getNewChunkPos(this.ownerMap.size() + 1, player.getServer());
        DimDungeons.logMessageInfo("DIMENSIONAL DUNGEONS: Assigning player " + player.getName().getString() + " the build plot at (" + cpos.x + ", " + cpos.z + ")");
        OwnerData newOwner = new OwnerData(this, player.getUUID(), player.getName().getString());
        this.ownerMap.computeIfAbsent(cpos, cp -> newOwner);
        this.setDirty();
        return cpos;
    }

    protected ChunkPos getNewChunkPos(int numOtherPlayers, MinecraftServer server) {
        long generation_limit = DungeonUtils.getLimitOfPersonalBuildDimension(server);
        int plotsPerLimit = (int)(generation_limit / 512L);
        int destZ = numOtherPlayers / plotsPerLimit;
        int destX = numOtherPlayers % plotsPerLimit;
        return new ChunkPos(destX, destZ);
    }

    public void changeBlacklistMode(Player player, boolean isBlacklist) {
        OwnerData owner = this.getOwnerAtPos(this.getPosForOwner((LivingEntity)player));
        owner.isBlacklist = isBlacklist;
        this.ownerMap.put(this.getPosForOwner((LivingEntity)player), owner);
        this.setDirty();
    }

    public boolean getBlacklistMode(Player player) {
        OwnerData owner = this.getOwnerAtPos(this.getPosForOwner((LivingEntity)player));
        return owner.isBlacklist;
    }

    public boolean isNameOnGuestList(Player player, String guestName) {
        OwnerData owner = this.getOwnerAtPos(this.getPosForOwner((LivingEntity)player));
        return owner.guestList.contains(guestName);
    }

    public boolean toggleNameOnGuestList(Player player, String guestName) {
        OwnerData owner = this.getOwnerAtPos(this.getPosForOwner((LivingEntity)player));
        if (owner.guestList.contains(guestName)) {
            owner.guestList.remove(guestName);
            this.ownerMap.put(this.getPosForOwner((LivingEntity)player), owner);
            this.setDirty();
            return false;
        }
        owner.guestList.add(guestName);
        this.ownerMap.put(this.getPosForOwner((LivingEntity)player), owner);
        this.setDirty();
        return true;
    }

    public void clearGuestListForPlayer(Player player) {
        OwnerData owner = this.getOwnerAtPos(this.getPosForOwner((LivingEntity)player));
        owner.guestList.clear();
        this.ownerMap.put(this.getPosForOwner((LivingEntity)player), owner);
        this.setDirty();
    }

    public ArrayList<String> getGuestListForPlayer(Player player) {
        OwnerData owner = this.getOwnerAtPos(this.getPosForOwner((LivingEntity)player));
        return owner.guestList;
    }

    public boolean isPlayerAllowedInPersonalDimension(Player visitor, ChunkPos destination) {
        OwnerData owner = this.getOwnerAtPos(destination);
        if (owner == null) {
            return true;
        }
        String visitorName = visitor.getGameProfile().getName();
        visitorName = visitorName.replace("[", "");
        visitorName = visitorName.replace("]", "");
        if ((visitorName = visitorName.replace(" ", "")).contentEquals(owner.playerName) || visitor.isCreative() || DungeonConfig.disablePersonalDimSecurity) {
            return true;
        }
        if (owner.isBlacklist) {
            return !owner.guestList.contains(visitorName);
        }
        return owner.guestList.contains(visitorName);
    }

    public PersonalBuildData() {
    }

    public PersonalBuildData(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        ListTag allOwners = tag.getList("player_data", (int)tag.getId());
        for (Tag t : allOwners) {
            CompoundTag ownerTag = (CompoundTag)t;
            ChunkPos pos = new ChunkPos(ownerTag.getInt("x"), ownerTag.getInt("z"));
            UUID id = UUID.fromString(ownerTag.getString("uuid"));
            String name = ownerTag.getString("name");
            OwnerData owner = new OwnerData(this, id, name);
            if (ownerTag.contains("isBlacklist")) {
                owner.isBlacklist = ownerTag.getBoolean("isBlacklist");
            }
            if (ownerTag.contains("guestList")) {
                ListTag guests = ownerTag.getList("guestList", 8);
                for (Tag g : guests) {
                    StringTag guestName = (StringTag)g;
                    owner.guestList.add(guestName.getAsString());
                }
            }
            this.ownerMap.put(pos, owner);
        }
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag allOwners = new ListTag();
        this.ownerMap.forEach((chunkPos, owner) -> {
            CompoundTag ownerTag = new CompoundTag();
            ownerTag.putInt("x", chunkPos.x);
            ownerTag.putInt("z", chunkPos.z);
            ownerTag.putString("uuid", owner.uuid.toString());
            ownerTag.putString("name", owner.playerName);
            ownerTag.putBoolean("isBlacklist", owner.isBlacklist);
            if (owner.guestList != null && owner.guestList.size() > 0) {
                ListTag guests = new ListTag();
                owner.guestList.forEach(guest -> {
                    StringTag g = StringTag.valueOf((String)guest);
                    guests.add((Object)g);
                });
                ownerTag.put("guestList", (Tag)guests);
            }
            allOwners.add((Object)ownerTag);
        });
        tag.put("player_data", (Tag)allOwners);
        return tag;
    }

    public static PersonalBuildData create() {
        return new PersonalBuildData();
    }

    public static PersonalBuildData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        return new PersonalBuildData(tag, lookupProvider);
    }

    public void debugClearKnownOwners() {
        this.ownerMap.clear();
        this.setDirty();
    }

    public class OwnerData {
        UUID uuid;
        String playerName;
        ArrayList<String> guestList;
        boolean isBlacklist;

        OwnerData(PersonalBuildData this$0, Player player) {
            this.uuid = player.getUUID();
            this.playerName = player.getName().getString();
            this.guestList = new ArrayList();
            this.isBlacklist = false;
        }

        OwnerData(PersonalBuildData this$0, UUID id, String name) {
            this.uuid = id;
            this.playerName = name;
            this.guestList = new ArrayList();
            this.isBlacklist = false;
        }
    }
}

